package user;

import communication.CqeType;
import communication.CqeType.PolicyPreservation;
import communication.CqeType.PolicyType;

import server.parser.Formula;

/**
 * Repraesentiert einen Eintrag in der Sicherheitspolitik.
 * Jeder Eintrag hat einen Typ und eine Schutzzeitraum (wird nur fuer Updates verwendet).
 */
public class ConfidentialityPolicyItem extends IdAndFormula {
	private static final long serialVersionUID = -8809551162854171163L;
	
	private CqeType.PolicyType type;
	private CqeType.PolicyPreservation preservation;
	
	public ConfidentialityPolicyItem( int id, Formula formula, PolicyType type, PolicyPreservation preservation ) {
		super(id, formula);
		this.type = type;
		this.preservation = preservation;
	}

	/**
	 * Gibt den Typ der Sicherheitspolitik zurueck (z.B. potentielles Geheimnis).
	 * 
	 * @return Typ der Sicherheitspolitik.
	 */
	public CqeType.PolicyType getType() {
		return type;
	}

	/**
	 * Setzt einen neuen Typ fuer die Sicherheitspolitik.
	 * 
	 * @param type Neuer Typ der Sicherheitspolitik.
	 */
	public void setType(CqeType.PolicyType type) {
		this.type = type;
	}

	/**
	 * Gibt den Schutzzeitraum dieser Sicherheitspolitik zurueck (z.B. dauerhaft).
	 * 
	 * @return Schutzzeitraum der Sicherheitspolitik.
	 */
	public CqeType.PolicyPreservation getPreservation() {
		return preservation;
	}

	/**
	 * Setzt einen neuen Schutzzeitraum fuer diese Politik.
	 * 
	 * @param preservation Neuer Schutzzeitraum.
	 */
	public void setPreservation(CqeType.PolicyPreservation preservation) {
		this.preservation = preservation;
	}
}
