package server.util;

import java.util.Collection;

import org.apache.log4j.Logger;


/**
 * This class contains all these little helper methods that have no home.
 * Please consider making a donation for homeless methods.
 */
public class CommonUtil {
	private final static Logger logger = Logger.getLogger("edu.udo.cs.ls6.cie.server.core");

	public static <T extends CloneableWithCloneMethod<T>, S extends Collection<T>> S cloneCollection( S collection ) {
		try {
			@SuppressWarnings("unchecked")
			S newCollection = (S)collection.getClass().newInstance();
			for ( T child : collection ) {
				newCollection.add( child.clone() );
			}
			return newCollection;
		} catch (InstantiationException e) {
			logger.error( e.getMessage() );
		} catch (IllegalAccessException e) {
			logger.error( e.getMessage() );
		}
		
		return null;
	}
}
