package server.start;

import java.io.IOException;
import java.net.Socket;

import org.apache.log4j.Logger;

import client.core.Client;
import server.core.Server;


public class QuickStart {
	protected final static Logger logger = Logger.getLogger("edu.udo.cs.ls6.cie.server");

	public static class ServerThread extends Thread {

		public ServerThread() {
			super();
		}
		
		@Override
		public void run() {
			Server.main( new String[]{} );
		}
	}
	
	public static void main(String[] args) {
		// Server starten
		ServerThread serverThread = new ServerThread();
		serverThread.start();
		
		// warten bis der Server gestartet ist
		try {
			Thread.sleep(500);
		}
		catch( InterruptedException e ) {
			// ignorieren
		}
		
		// Client starten
		try {
			Socket client_socket = new Socket( "localhost", 65000 );
			Client.GUI = new Client( client_socket );
		}
		catch( IOException e ) {
			logger.fatal("Error while starting client.", e);
		}
	}
}
