package server.parser.node;

import server.parser.Formatter.FormulaFormatter;

public class ImplicationNode extends ConnectorNode {
	private static final long serialVersionUID = 818382576562750477L;

	public ImplicationNode() {
	}
	
	@Override
	public boolean isImplicationNode() {
		return true;
	}

	@Override
	protected String getJunctor(FormulaFormatter formatter) {
		return formatter.getImplication();
	}
	
	@Override
	public void transformImplication() {
		Node a = this.getChild(0);
		Node b = this.getChild(1);
		
		DisjunctorNode or = new DisjunctorNode();
		or.addOperand( new NegationNode(a) );
		or.addOperand( b );
		
		this.getParent().replaceChild(this, or);
		
		// Rekursiver Aufruf.
		a.transformImplication();
		b.transformImplication();
	}
}
