package server.parser.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import exception.UnsupportedFormulaException;

import server.parser.Formatter.FormulaFormatter;


public class DisjunctorNode extends ConnectorNode {
	private static final long serialVersionUID = -2293105491190690102L;

	public DisjunctorNode() {
	}
	
	public DisjunctorNode( List<Node> nodes ) {
		this.addChildren( nodes );
	}
	
	@Override
	public boolean isDisjunctorNode() {
		return true;
	}

	@Override
	protected String getJunctor(FormulaFormatter formatter) {
		return formatter.getDisjunctor();
	}

	@Override
	public Set<String> rr() {
		Set<String> retVal = null;
		// Schnittmengen: der Anfangswert muss mit einer Menge initialisiert.   
		Node first_operand = getOperands().get(0);
		Set<String> first_operand_rr = first_operand.rr();
		if (first_operand_rr != null) {
			retVal = new HashSet<String>(first_operand_rr); 
		} else {
			return null;
		}
		 
		for (Node operand : getOperands()) {
			Set<String> op_rr = operand.rr();
			if (op_rr != null) {
				retVal.retainAll(op_rr);
			} else {
				return null;
			}
		}
		return retVal;
	}
	
	@Override
	public Node flatten() {
		return this.makeFlat();
	}
	
	@Override
	protected void pushNegations( boolean foundNegation, boolean skipNegatedExistentialQuantifiers ) throws UnsupportedFormulaException {
		if ( foundNegation ) {
			// Negation vor Disjunktion => Konjunktion
			ConjunctorNode conj = new ConjunctorNode( this.getChildren() );
			this.getParent().replaceChild(this, conj);
		}
		
		// Rekursiver Aufruf. Kopie der Kindliste verwendet, da die originalliste im Aufruf ueber replaceChild()
		// geaendert werden kann und dadurch eine ConcurrentModificationException auftritt.
		List<Node> children = new ArrayList<Node>(this.getChildren());
		for ( Node child : children ) {
			child.pushNegations(foundNegation, skipNegatedExistentialQuantifiers);
		}
	}
}
