package server.parser.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import exception.UnsupportedFormulaException;

import server.parser.Formatter.FormulaFormatter;


public class ConjunctorNode extends ConnectorNode {
	private static final long serialVersionUID = -3626406784610711137L;

	public ConjunctorNode() {
	}
	
	public ConjunctorNode( List<Node> nodes ) {
		this.addChildren( nodes );
	}

	@Override
	public boolean isConjunctorNode() {
		return true;
	}

	@Override
	protected String getJunctor(FormulaFormatter formatter) {
		return formatter.getConjunctor();
	}
	
	@Override
	public Set<String> rr() {
		Set<String> retVal = new HashSet<String>();
		
		for (Node operand : getOperands()) {
			// Operand ist EqualityNode und Gleichheit -> Fallunterscheidung
			if ( operand.isEqualityNode() && ((EqualityNode)operand).getEquals() ) {
				EqualityNode equality = (EqualityNode)operand;
				
				if ( equality.getLeftOperand().isVariableNode() && equality.getRightOperand().isVariableNode() ) {
					// phi_1 AND x=y oder phi_1 AND x=x
					
					Set<String> eqVars = new HashSet<String>();
					eqVars.add( ((VariableNode)equality.getLeftOperand()).getVariable() );
					eqVars.add( ((VariableNode)equality.getRightOperand()).getVariable() );
					Set<String> clonedEqVars = new HashSet<String>( eqVars );
					
					// Schnittmenge bilden => eqVars veraendert!
					eqVars.retainAll( retVal );
					
					if ( !eqVars.isEmpty() ) {
						// Schnittmenge nicht leer -> Variablen aus EqualityNode hinzufügen
						retVal.addAll( clonedEqVars );
					} else {
						// Schnittmenge leer -> Variablen aus EqualityNode verwerfen
						continue;
					}
				}
				
				// Mind. eine Konstante => rr() rekursiv verwenden
				retVal.addAll( operand.rr() );
			}
			else {
				// Operand ist kein EqualityNode -> retVal die berechnete rr-Menge hinzufuegen
				Set<String> operand_rr = operand.rr();
				if( operand_rr == null ) {
					// rr fuer Operand nicht definiert (bottom)
					// bottom (=null) weiter nach oben propagieren
					return null;
				}
				else {
					retVal.addAll( operand.rr() );
				}
			}
		}
		
		return retVal;
	}
	
	@Override
	public Node flatten() {
		return this.makeFlat();
	}
	
	@Override
	protected void pushNegations( boolean foundNegation, boolean skipNegatedExistentialQuantifiers ) throws UnsupportedFormulaException {
		if ( foundNegation ) {
			// Negation vor Konjunktion => Disjunktion
			DisjunctorNode disj = new DisjunctorNode( this.getChildren() );
			this.getParent().replaceChild(this, disj);
		}
		
		// Rekursiver Aufruf. Kopie der Kindliste verwendet, da die originalliste im Aufruf ueber replaceChild()
		// geaendert werden kann und dadurch eine ConcurrentModificationException auftritt.
		List<Node> children = new ArrayList<Node>(this.getChildren());
		for ( Node child : children ) {
			child.pushNegations(foundNegation, skipNegatedExistentialQuantifiers);
		}
	}
}