package server.parser.node;

import server.parser.Formatter.FormulaFormatter;

public class BooleanNode extends ConstantNode {
	private static final long serialVersionUID = 6156077188292473942L;

	public BooleanNode(String booleanValue) {
		super( booleanValue );
	}
	
	@Override
	public boolean isBooleanNode() {
		return true;
	}

	@Override
	public String toString(FormulaFormatter formulaformatter) {
		return formulaformatter.processBoolean( this.getConstant() );
	}
}
