package server.database.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import exception.DatabaseException;

public class SQLTable implements Iterable<String[]> {
	
	private String[] columnNames = null;
	private Vector<String[]> rows = null;
	
	public SQLTable( ResultSet result ) throws SQLException {
		this.columnNames = new String[0];
		this.rows = new Vector<String[]>();
		int size = 0;
		
		if ( result == null || result.isClosed() ) {
			return;
		}
		
		// Get Column Names
		try {
			ResultSetMetaData md = result.getMetaData();
			size = md.getColumnCount();
			this.columnNames = new String[size];
			for ( int i = 0; i < size; i++ ) {
				// Spalten fangen bei 1 an, deshalb i+1
				this.columnNames[i] = md.getColumnName(i+1);
			}
		} catch ( SQLException exception ) {
			exception.printStackTrace();
			return;
		}
		
		// Get Data
		while ( result.next() ) {
			String[] row = new String[size];
			for ( int i = 0; i < size; i++ ) {
				row[i] = result.getString( i+1 );
			}
			this.rows.add( row );
		}
	}

	public int getColumnCount() {
		return this.columnNames.length;
	}

	public String getColumnName( int column ) {
		return this.columnNames[column];
	}
	
	public String[] getColumnNames() {
		return this.columnNames;
	}

	public int getRowCount() {
		return this.rows.size();
	}

	public String getValueAt( int row, int column ) throws DatabaseException {
		if( row >= rows.size() )
			throw new DatabaseException("Ergebnis enthaelt zu wenig Zeilen!\nGroesse des Ergebnisses: " + rows.size() + "\nAngeforderte Zeile: " + (row+1), null);
		return this.rows.get(row)[column];
	}
	
	public Map<String,String> getRow( int row ) throws DatabaseException {
		if( row >= rows.size() ) {
			throw new DatabaseException("Ergebnis enthaelt zu wenig Zeilen!\nGroesse des Ergebnisses: " + rows.size() + "\nAngeforderte Zeile: " + (row+1), null);
		}
		
		String[] rowData = this.rows.get( row );
		HashMap<String,String> result = new HashMap<String,String>( rowData.length );
		
		for ( int i = 0; i < rowData.length; i++ ) {
			result.put( this.columnNames[i], rowData[i] );
		}
		
		return result;
	}
	
	public String[] getFirstRow() throws DatabaseException {
		if ( rows.size() == 0 ) {
			throw new DatabaseException("Empty result.", null);
		}
		
		return this.rows.get(0);
	}

	@Override
	public Iterator<String[]> iterator() {
		return this.rows.iterator();
	}
	
	@Override
	public String toString() {
		String result = "";
		
		for( String[] row : this ) {
			result += "{";
			String sep = "";
			for ( String column : row ) {
				result += sep + column;
				sep = ", ";
			}
			result += "}";
		}
		
		return result;
	}
}
