package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class UserTableSchema extends TableSchema {
	
	public final static SchemaColumn ID = new SchemaColumn("ID", "NUMBER(7,0)", true, true, true);
	public final static SchemaColumn LOGIN = new SchemaColumn("LOGIN", "VARCHAR2(50 BYTE)", true, false, false, true, null, null);
	public final static SchemaColumn PASSWORD = new SchemaColumn("PASSWORD", "VARCHAR2(50 BYTE)", true);
	public final static SchemaColumn ROLE_ID = new SchemaColumn("ROLE_ID", "NUMBER(7,0)", true, RoleTableSchema.ID);
	public final static SchemaColumn CENSOR = new SchemaColumn("CENSOR", "VARCHAR2(100 BYTE)", true);

	public UserTableSchema() throws DatabaseException {
		super("CQEUSER", ID, LOGIN, PASSWORD, ROLE_ID, CENSOR);
	}
}
