package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

/**
 * Tabellen-Schema fuer den flexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesFlexibleSignaturesSchema extends TableSchema {

	public final static SchemaColumn SIG_ID = new SchemaColumn("SIG_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn RELATIONNAME = new SchemaColumn("RELATIONNAME", "VARCHAR2(30 BYTE)", true);
	public final static SchemaColumn USER_ID = new SchemaColumn("USER_ID", "NUMBER(7,0)", true);
	
	public SignaturesFlexibleSignaturesSchema() throws DatabaseException {
		super("SIGS_FLEX_SIGNATURES", SIG_ID, RELATIONNAME, USER_ID);
	}
}
