package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

/**
 * Tabellen-Schema fuer den flexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesFlexibleSignaturesPAVSchema extends TableSchema {
	
	public final static SchemaColumn SIG_ID = new SchemaColumn("SIG_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn P_ID = new SchemaColumn("P_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn ATTRIBUTE = new SchemaColumn("ATTRIBUTE", "VARCHAR2(30 BYTE)", true, true);
	public final static SchemaColumn VALUE = new SchemaColumn("VALUE", "VARCHAR2(50 BYTE)", true);
	
	public SignaturesFlexibleSignaturesPAVSchema() throws DatabaseException {
		super("SIGS_FLEX_SIGNATURES_PAV", SIG_ID, P_ID, ATTRIBUTE, VALUE);
	}
}
