package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

/**
 * Tabellen-Schema fuer den flexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesFlexibleQuerySchema extends TableSchema {
	
	public final static SchemaColumn QUERY_ID = new SchemaColumn("QUERY_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn USER_ID = new SchemaColumn("USER_ID", "NUMBER(7,0)", true);
	public final static SchemaColumn REACTION = new SchemaColumn("REACTION", "VARCHAR2(20 BYTE)", false);
	public final static SchemaColumn RELATIONNAME = new SchemaColumn("RELATIONNAME", "VARCHAR2(30 BYTE)", true);
	public final static SchemaColumn PROCESSING_TIME = new SchemaColumn("PROCESSING_TIME", "NUMBER(7,0)", false);
	
	public SignaturesFlexibleQuerySchema() throws DatabaseException {
		super("SIGS_FLEX_QUERY", QUERY_ID, USER_ID, REACTION, RELATIONNAME, PROCESSING_TIME);
	}
}
