package server.database.schema.maintenance;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

/**
 * Tabellen-Schema fuer den flexiblen statischen SignatureCensor.
 * 
 * Achtung: Fuer eine korrekte Funktionsweise des SignatureCensors muss zusaetzlich zur 
 * Generierung des Schemas auch die sql-Datei 'staticSignatureCensorExperimentCreate.sql', 
 * die u.a. die Trigger fuer den SignatureCensor enthaelt, in der Datenbank ausgefuehrt 
 * werden.
 */
public class SignaturesFlexiblePotSecTableSchema extends TableSchema {

	public final static SchemaColumn POT_SEC_ID = new SchemaColumn("POT_SEC_ID", "NUMBER(7,0)", true, true);
	public final static SchemaColumn RELATIONNAME = new SchemaColumn("RELATIONNAME", "VARCHAR2(30 BYTE)", true, false);
	public final static SchemaColumn USER_ID = new SchemaColumn("USER_ID", "NUMBER(7, 0)", true, true);
	
	public SignaturesFlexiblePotSecTableSchema() throws DatabaseException {
		super("SIGS_FLEX_POT_SEC", POT_SEC_ID, RELATIONNAME, USER_ID);
	}
}
