package server.database.schema.app;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class StudentenTableSchema extends TableSchema {
	
	public final static SchemaColumn MATRIKELNR = new SchemaColumn("MATRIKELNR", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn STUDENT = new SchemaColumn("STUDENT", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn GEBURTSTAG = new SchemaColumn("GEBURTSTAG", "VARCHAR2(400 BYTE)", true);
	
	public StudentenTableSchema() throws DatabaseException {
		this("STUDENTEN");
	}
	
	public StudentenTableSchema(String tablename) throws DatabaseException {
		super(tablename, MATRIKELNR, STUDENT, GEBURTSTAG);
	}
}
