package server.database.schema.app;

import exception.DatabaseException;
import server.database.schema.SchemaColumn;
import server.database.schema.TableSchema;

public class KrankheitTableSchema extends TableSchema {
	
	public final static SchemaColumn SYMPTOM = new SchemaColumn("SYMPTOM", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn DIAGNOSIS = new SchemaColumn("DIAGNOSIS", "VARCHAR2(400 BYTE)", true);
	public final static SchemaColumn PATIENT = new SchemaColumn("PATIENT", "VARCHAR2(400 BYTE)", true);
	
	public KrankheitTableSchema() throws DatabaseException {
		this("KRANKHEIT");
	}
	
	public KrankheitTableSchema(String tablename) throws DatabaseException {
		super(tablename, SYMPTOM, DIAGNOSIS, PATIENT);
	}
}
