package server.database.schema.app;

import exception.DatabaseException;
import server.database.NewMaintenanceDatabase;
import server.database.schema.maintenance.MaintenanceDatabaseSchema;
import server.database.sql.SQLDatabase;
import server.database.sql.SQLExpression;

public class ArmbruchBeinbruchKrankheitExample extends MaintenanceDatabaseSchema {
	
	public final ArmbruchTableSchema armbruch;
	public final BeinbruchTableSchema beinbruch;
	public final KrankheitTableSchema krankheit;
	
	public ArmbruchBeinbruchKrankheitExample() throws DatabaseException {
		super("Armbruch Beinbruch Krankheit Example");
		
		this.armbruch = new ArmbruchTableSchema();
		this.beinbruch = new BeinbruchTableSchema();
		this.krankheit = new KrankheitTableSchema();
		
		this.appTables.add(armbruch);
		this.appTables.add(beinbruch);
		this.appTables.add(krankheit);
	}
	
	@Override
	public void fillAppDBWithContents(SQLDatabase db) throws DatabaseException {
		this.fillArmbruch(db);
		this.fillBeinbruch(db);
		this.fillKrankheit(db);
	}
	
	private void fillArmbruch(SQLDatabase db) throws DatabaseException {
		SQLExpression sql;
		
		sql = db.sql();
		sql.set( ArmbruchTableSchema.NAME, "Hans" );
		db.insert(this.armbruch);
		
		sql = db.sql();
		sql.set( ArmbruchTableSchema.NAME, "Heinz" );
		db.insert(this.armbruch);
		
		sql = db.sql();
		sql.set( ArmbruchTableSchema.NAME, "Helmut" );
		db.insert(this.armbruch);
	}
	
	private void fillBeinbruch(SQLDatabase db) throws DatabaseException {
		
	}
	
	private void fillKrankheit(SQLDatabase db) throws DatabaseException {
		SQLExpression sql;
		
		sql = db.sql();
		sql.set( KrankheitTableSchema.SYMPTOM, "Schwellung" );
		sql.set( KrankheitTableSchema.DIAGNOSIS, "Armbruch" );
		sql.set( KrankheitTableSchema.PATIENT, "Hans" );
		db.insert(this.krankheit);
		
		sql = db.sql();
		sql.set( KrankheitTableSchema.SYMPTOM, "Schwellung" );
		sql.set( KrankheitTableSchema.DIAGNOSIS, "Armbruch" );
		sql.set( KrankheitTableSchema.PATIENT, "Heinz" );
		db.insert(this.krankheit);
		
		sql = db.sql();
		sql.set( KrankheitTableSchema.SYMPTOM, "Schwellung" );
		sql.set( KrankheitTableSchema.DIAGNOSIS, "Armbruch" );
		sql.set( KrankheitTableSchema.PATIENT, "Helmut" );
		db.insert(this.krankheit);
	}
	
	@Override
	public void fillMaintenanceDBWithContents(NewMaintenanceDatabase mdb) throws DatabaseException {
		super.createDefaultAccessRights(mdb);
		super.createAdminUser(mdb);
		int userId = super.createTestUser(mdb, 1, "TestUser");
		this.fillPrior(mdb, userId);
		this.fillConfidentialityPolicy(mdb, userId);
	}
	
	public void fillPrior(NewMaintenanceDatabase db, int userId) throws DatabaseException {

	}
	
	public void fillConfidentialityPolicy(NewMaintenanceDatabase db, int userId) throws DatabaseException {

	}
}
