package server.database.schema;

import server.database.schema.app.ArmbruchBeinbruchKrankheitExample;
import server.database.schema.app.IllTreatExample;
import server.database.schema.app.KrankheitExample;
import server.database.schema.app.PreCQEFirstExample;
import server.database.schema.app.PreCQEIllTreatEffectsExample;
import server.database.schema.app.PreCQEInventionExample;
import server.database.schema.app.PreCQEKrankheitExample;
import server.database.schema.app.PreCQEKrankheitExampleLena;
import server.database.schema.app.PreCQEKrankheitInventionExample;
import server.database.schema.app.PreCQESecondExample;
import server.database.schema.app.PreCQEStudentenExample;
import server.database.schema.app.SignatureExperimentExample;
import server.database.schema.app.SignatureExperimentSchema;
import server.database.schema.app.OpencensorsTestExample;
import server.database.schema.app.StudentenExample;
import server.database.schema.app.StudentenTableSchema;
import server.database.schema.app.UpdateCensorTestExample;
import server.database.schema.maintenance.MaintenanceDatabaseSchema;
import exception.DatabaseException;

public class Schema {

	public static MaintenanceDatabaseSchema maintenanceDatabase;
	
	public static DatabaseSchema studentenExampleDatabase;
	public static DatabaseSchema preCQEStudentenExampleDatabase;
	
	public static DatabaseSchema preCQEFirstExampleDatabase;
	public static DatabaseSchema preCQESecondExampleDatabase;
	public static DatabaseSchema preCQEKrankheitExampleDatabase;
	public static DatabaseSchema preCQEInventionExampleDatabase;
	public static DatabaseSchema preCQEKrankheitInventionExampleDatabase;
	public static DatabaseSchema preCQEKrankheitExampleLenaDatabase;
	public static DatabaseSchema preCQEIllTreatEffectsExampleDatabase;
	
	public static DatabaseSchema signatureExperimentDatabase;
	public static DatabaseSchema signatureExperimentDatabaseWithContents;
	
	public static DatabaseSchema armbruchBeinbruchKrankheitDatabase;
	
	public static DatabaseSchema illTreatExample;
	
	public static DatabaseSchema krankheitExample;
	
	public static DatabaseSchema opencensorsTestExample;
	public static DatabaseSchema updateCensorTestExample;
	
	
	public static DatabaseSchema[] databases;
	
	static {
		try {
			maintenanceDatabase = new MaintenanceDatabaseSchema();
			
			studentenExampleDatabase = new StudentenExample();
			preCQEStudentenExampleDatabase = new PreCQEStudentenExample();
			
			
			preCQEFirstExampleDatabase = new PreCQEFirstExample();
			preCQESecondExampleDatabase = new PreCQESecondExample();
			preCQEKrankheitExampleDatabase = new PreCQEKrankheitExample();
			preCQEInventionExampleDatabase = new PreCQEInventionExample();
			preCQEKrankheitInventionExampleDatabase = new PreCQEKrankheitInventionExample();
			preCQEKrankheitExampleLenaDatabase = new PreCQEKrankheitExampleLena();
			preCQEIllTreatEffectsExampleDatabase = new PreCQEIllTreatEffectsExample();
			
			signatureExperimentDatabase = new SignatureExperimentSchema();
			signatureExperimentDatabaseWithContents = new SignatureExperimentExample();
			
			armbruchBeinbruchKrankheitDatabase = new ArmbruchBeinbruchKrankheitExample();
			
			illTreatExample = new IllTreatExample();
			
			krankheitExample = new KrankheitExample();
			
			opencensorsTestExample = new OpencensorsTestExample();
			updateCensorTestExample = new UpdateCensorTestExample();
			
			databases = new DatabaseSchema[] {
					maintenanceDatabase,
					studentenExampleDatabase,
					preCQEStudentenExampleDatabase,			
					preCQEFirstExampleDatabase,
					preCQESecondExampleDatabase,
					preCQEKrankheitExampleDatabase,
					preCQEInventionExampleDatabase,
					preCQEKrankheitInventionExampleDatabase,
					preCQEKrankheitExampleLenaDatabase,
					preCQEIllTreatEffectsExampleDatabase,
					
					signatureExperimentDatabase,
					signatureExperimentDatabaseWithContents,
					armbruchBeinbruchKrankheitDatabase,
					illTreatExample,
					krankheitExample,
					
					opencensorsTestExample,
					updateCensorTestExample
			};
		} catch (DatabaseException e) {
			e.printStackTrace();
		}
	}
}
