package server.data;

import exception.DatabaseException;
import exception.ParserException;
import server.database.schema.Schema;
import server.database.schema.maintenance.PriorAllTableSchema;
import server.database.sql.SQLDatabase;
import server.database.sql.SQLSelect;
import server.database.sql.SQLTable;
import server.parser.Formula;

public class PriorAll extends IdAndFormulaTable {

	/**
	 * Each database instance has exactly one PriorAll instance.
	 * Therefore do not use this constructor outside of NewMaintenanceDatabase!
	 * 
	 * @param db
	 * @throws DatabaseException
	 */
	public PriorAll(SQLDatabase db) throws DatabaseException {
		super(db, Schema.maintenanceDatabase.priorAll);
		
		// Load entries from database.
		SQLSelect sql = this.db.newSelect();
		sql.select(PriorAllTableSchema.ID).select(PriorAllTableSchema.FORMULA);
		sql.from(Schema.maintenanceDatabase.priorAll);
		
		SQLTable result = sql.get();
		for ( String[] row : result ) {
			try {
				int id = Integer.valueOf( row[0] );
				Formula formula = new Formula( row[1] );
				
				// Create new IdAndFormulaEntry and add to list.
				IdAndFormulaEntry entry = new IdAndFormulaEntry(this, id, formula);
				this.entries.add( entry );
			} catch (ParserException e) {
				throw new DatabaseException("Unable to parse prior all entry (malformed formula)", e);
			} catch (NumberFormatException e) {
				throw new DatabaseException("Unable to parse prior all entry (malformed id)", e);
			}
		}
	}
}
