package server.core.notificationHandler;

import java.io.IOException;
import java.util.EnumSet;

import communication.CqeType;
import exception.DatabaseException;
import exception.UnknownUserException;

import server.core.Client;
import server.data.Role;
import server.data.User;
import notification.clientToServer.EditUserNotification;
import notification.serverToClient.OkayNotification;

public class EditUserNotificationHandler extends NotificationHandler<EditUserNotification> {

	public EditUserNotificationHandler() {
		super(EditUserNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, EditUserNotification notification) throws DatabaseException, IOException, UnknownUserException {
		User user = client.getMaintenanceDB().getUserManagement().load( notification.getUserId() );
		
		if ( notification.getUsername() != null ) {
			user.setUsername( notification.getUsername() );
		}
		if ( notification.getPassword() != null ) {
			user.setPassword( notification.getPassword() );
		}
		if ( notification.getRole() != null ) {
			user.setRole( Role.load(client.getMaintenanceDB().getDb(), notification.getRole().getRoleId()) );
		}
		
		client.send( new OkayNotification() );
	}

}
