package server.core.notificationHandler;

import java.io.IOException;
import java.util.EnumSet;

import communication.CqeType;
import exception.DatabaseException;
import exception.UnknownUserException;

import server.core.Client;
import server.data.User;
import notification.clientToServer.DeleteUserNotification;
import notification.serverToClient.OkayNotification;

public class DeleteUserNotificationHandler extends NotificationHandler<DeleteUserNotification> {

	public DeleteUserNotificationHandler() {
		super(DeleteUserNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, DeleteUserNotification notification) throws DatabaseException, IOException, UnknownUserException {
		User user = client.getMaintenanceDB().getUserManagement().load(notification.getUserID());
		client.getMaintenanceDB().getUserManagement().delete( user );
		client.send( new OkayNotification() );
	}

}
