package server.core.notificationHandler;

import java.io.IOException;
import java.util.EnumSet;

import communication.CqeType;
import exception.DatabaseException;
import exception.ParserException;
import exception.UnknownUserException;
import exception.UnsupportedFormulaException;

import notification.clientToServer.AddUserInformationNotification;
import notification.serverToClient.OkayNotification;
import server.core.Client;
import server.data.User;
import server.parser.Formula;
import server.parser.FormulaUtil;
import user.ConfidentialityPolicyItem;
import user.IdAndFormula;

public class AddUserInformationNotificationHandler extends NotificationHandler<AddUserInformationNotification> {

	public AddUserInformationNotificationHandler() {
		super(AddUserInformationNotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, AddUserInformationNotification notification) throws IOException, UnsupportedFormulaException, DatabaseException, UnknownUserException, ParserException {
		User user = client.getMaintenanceDB().getUserManagement().load(notification.getUserId());
		
		Formula formula = new Formula( notification.getFormula() );

		// FIXME: range restriction check here?
		if( !FormulaUtil.rangerestricted(formula.clone()) ) {
			throw new UnsupportedFormulaException("Formula " + formula.toString() + " is not safe range!");
		}
		
		switch ( notification.getType() ) {
		case IdAndFormula.TYPE_CONF_POL:
			user.getConfidentialityPolicy().add(formula, notification.getPolicyType(), notification.getPreservation());
			// FIXME: Workaround until new communication protocol is available 
			client.send( new OkayNotification( new ConfidentialityPolicyItem(user.getId(), formula, notification.getPolicyType(),notification.getPreservation()) ) );
			break;
			
		case IdAndFormula.TYPE_LOG:
			Formula answer = new Formula( notification.getFormula() );
			formula.setInteractionType( CqeType.InteractionType.QUERY );
			user.getLog().add(formula, null, answer, null);
			// FIXME: Workaround until new communication protocol is available 
			client.send( new OkayNotification( new IdAndFormula(user.getId(), formula)));			
			break;
			
		case IdAndFormula.TYPE_PRIOR:
			user.getPriorUser().add(formula);
			// FIXME: Workaround until new communication protocol is available 
			client.send( new OkayNotification( new IdAndFormula(user.getId(), formula)));			
			break;
			
		default:
			// FIXME exception type doesn't fit very well
			throw new UnsupportedFormulaException( notification.getFormula() );
		}
	}

}
