package server.censor.signature.util;

import java.util.Arrays;

public class TemplateDependencyRow {

	private TemplateDependencyElement[] row;
	
	public TemplateDependencyRow(int attributeCount) {
		this.row = new TemplateDependencyElement[attributeCount];
		for( int i=0; i<attributeCount; ++i ){
			this.row[i] = new NonDistinguishedSymbolElement("nds_"+i);
		}
	}
	
	public TemplateDependencyRow(TemplateDependencyRow copy) {
		this.row = new TemplateDependencyElement[copy.getAttributeCount()];
		for( int i=0; i<copy.getAttributeCount(); ++i ) {
			this.row[i] = copy.getElement(i).copy();
		}
	}
	
	public int getAttributeCount() {
		return this.row.length;
	}
	
	public TemplateDependencyElement getElement(int attribute) {
		return this.row[attribute];
	}
	
	public void setElement(int attribute, TemplateDependencyElement element) {
		this.row[attribute] = element;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(row);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof TemplateDependencyRow))
			return false;
		TemplateDependencyRow other = (TemplateDependencyRow) obj;
		if (!Arrays.equals(row, other.row))
			return false;
		return true;
	}
}
