package server.censor.signature.util;

import java.util.HashSet;
import java.util.Set;

import exception.UnsupportedFormulaException;

import server.parser.Formula;
import server.parser.node.AtomPredicateNode;
import server.parser.node.ConstantNode;
import server.parser.node.ExistentialQuantifiedNode;
import server.parser.node.Node;

public class SignatureConfidentialityPolicyItem {

	private int id;
	private int userID;
	private String relationname;
	private String[] attributeValues;
	
	public SignatureConfidentialityPolicyItem(int id, int userID,  String relationname, String[] attributeValues) {
		this.id = id;
		this.userID = userID;
		this.relationname = relationname;
		this.attributeValues = attributeValues;
	}
	
	public int getID() {
		return id;
	}
	
	public int getUserID() {
		return userID;
	}
	
	public String getRelationname() {
		return relationname;
	}
	
	public int getAttributeCount() {
		return attributeValues.length;
	}
	
	public String[] getAttributeValues() {
		return attributeValues;
	}
	
	public String getAttributeValue(int attribute) {
		return attributeValues[attribute];
	}
	
	/**
	 * Bestimmt die Menge der Attribute, die mit einer Konstanten belegt sind.
	 * Dies sind alle Attribute, die kein '*' enthalten.
	 * 
	 * @return Menge der Attribute, die mit einer Konstante belegt sind
	 */
	public Set<Integer> getAttributesWithConstants() {
		Set<Integer> attributesWithConstants = new HashSet<Integer>();
		for( int i=0; i<attributeValues.length; ++i ) {
			if( ! attributeValues[i].equals("*") ) {
				attributesWithConstants.add(i);
			}
		}
		
		return attributesWithConstants;
	}
	
	public static SignatureConfidentialityPolicyItem createSignatureConfidentialityPolicyItem(int id, int userID, Formula formula) throws UnsupportedFormulaException {
		// erfuellt die gegebene Formel die Einschraenkungen des SignatureCensors?
		if( ! formula.getLanguageTypes().contains("existential_r_sentence") ) {
			throw new UnsupportedFormulaException("Error while creating a confidentiality policy element for the SignatureCensor: Formula " + formula.toString() + " is not an existential r-sentence!");
		}
				
		// Formel in einzelne Teile zerlegen
		// quantifiziertes Relationsatom ermitteln
		Node node = formula.getRootChild();
		while( node.isExistentialQuantifiedNode() ) {
			node = ((ExistentialQuantifiedNode)node).getQuantifiedFormula();
		}
		AtomPredicateNode atomPred = (AtomPredicateNode)node;
		// Relation und Attributwerte aus Relationsatom extrahieren
		String relation = atomPred.getRelationname();
		String[] attributeValues = new String[atomPred.getChildrenNumber()-1];
		int i = 0;
		for( Node child : atomPred.getChildren() ) {
			if( child.isRelationnameNode() ) {
				continue;
			}
			else if( child.isVariableNode() )
				attributeValues[i] = "*";
			else
				attributeValues[i] = ((ConstantNode)child).getConstant();
			++i;
		}
		
		return new SignatureConfidentialityPolicyItem(id, userID, relation, attributeValues);
	}
}
