package server.censor.signature;

import java.util.ArrayList;

import exception.DatabaseException;
import exception.UnsupportedFormulaException;

import server.core.Client;
import server.core.Server;
import server.parser.Formula;

/**
 * Klasse für den Zensor, der die unflexible statische signaturbasierte Zugriffskontrolle realisiert.
 */
public class UnflexibleStaticSignatureCensor extends StaticSignatureCensor {
	
	public UnflexibleStaticSignatureCensor(Server server) throws DatabaseException {
		super("UnflexibleStaticSignature", server);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String writeToCQEQuery( Client client, ArrayList<String> CQE_Query, Formula interaction, String[] ColumnNames, String relationname ) throws DatabaseException, UnsupportedFormulaException {
		return this.maintenanceUtil.writeToCQEQueryUnflexible(client.getMaintenanceDB().getDb(), CQE_Query, interaction, ColumnNames, relationname, client.getUser().getId());
	}
}
