package server.censor.precqe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

import communication.CqeType;

import exception.DatabaseException;
import exception.NoInstanceFoundException;
import exception.UnknownUserException;
import exception.UnsupportedFormulaException;
import server.core.Client;
import server.core.notificationHandler.NotificationHandler;
import server.data.User;
import server.database.OracleSQLAppDatabase;
import user.ConfidentialityPolicyItem;
import user.IdAndFormula;
import notification.Notification;
import notification.clientToServer.PreCQENotification;
import notification.serverToClient.OkayNotification;

public class PreCQENotificationHandler extends NotificationHandler<PreCQENotification> {

	public PreCQENotificationHandler() {
		super(PreCQENotification.class, EnumSet.of(CqeType.Right.MANAGE_USERS));
	}

	@Override
	protected void handle(Client client, PreCQENotification notification) throws DatabaseException, UnsupportedFormulaException, NoInstanceFoundException, IOException, UnknownUserException {
		// Gather some data.
		User user = client.getMaintenanceDB().getUserManagement().load( notification.getUser().getUserId() );
		List<IdAndFormula> prior = new ArrayList<IdAndFormula>();
		prior.addAll( client.getMaintenanceDB().getPriorAll().getCopyAsList() );
		prior.addAll( user.getPriorUser().getCopyAsList() );
		List<IdAndFormula> schemaConstraints = client.getMaintenanceDB().getSchemaConstraints().getCopyAsList();
		List<ConfidentialityPolicyItem> confPol = user.getConfidentialityPolicy().getCopyAsList();
		
		Notification answer;
		
		PreCQE preCQE = new PreCQE( (OracleSQLAppDatabase)client.getApplicationDB(), client.getMaintenanceDB(), String.valueOf(user.getId()), confPol, prior, schemaConstraints );
		
		if ( !notification.getCleanup() ) {
			// Calculate instance.
			answer = preCQE.createInferenceProofInstance();
		} else {
			// Cleanup instance.
			preCQE.cleanup();
			answer = new OkayNotification();
		}
		
		// Send answer.
		client.send(answer);
	}

}
