package server.censor;

import org.apache.log4j.Logger;

import server.core.Server;

public abstract class Censor {
	protected final static Logger logger = Logger.getLogger("edu.udo.cs.ls6.cie.server.censor");
	
	private final String name;
	private Server server;

	public Censor( String censorName, Server server ) {
		this.name = censorName;
		this.server = server;
	}
	
	/**
	 * Returns the server this censor instance is tied to.
	 * @return
	 */
	public Server getServer() {
		return this.server;
	}
	
	/**
	 * Returns the unique name of the censor.
	 * 
	 * @return Unique name of the censor.
	 */
	public String getName() {
		return this.name;
	}
	
	/**
	 * Returns the string representation of this censor.
	 * The default is the censor name.
	 */
	@Override
	public String toString() {
		return this.getName();
	}
}
