package notification.serverToClient;

import java.util.List;

import notification.Notification;

import user.IdAndFormula;

/**
 * Notification fuer das Ergebnis nach einem evaluate()-Aufruf in der Applikation.
 */
public abstract class ResultNotification extends Notification {
	private static final long serialVersionUID = 4639961787359320588L;
	
	private String interaction;
	private List<IdAndFormula> addToLog;
	private long processingTime;

	/**
	 * Erstellt eine neue Antwort, die die urspruengliche Interaktion des Benutzers und
	 * eine Liste von Formeln, die ins Log aufgenommen werden sollen, enthaelt.
	 * @param interaction Die urspruengliche Interaktion.
	 * @param addToLog Neues Wissen, was der Benutzer ins Log aufnehmen muss.
	 */
	public ResultNotification( String interaction, List<IdAndFormula> addToLog ) {
		this.interaction = interaction;
		this.addToLog = addToLog;
		this.processingTime = -1;
	}
	
	/**
	 * Erstellt eine neue Antwort, die die urspruengliche Interaktion des Benutzers,
	 * eine Liste von Formeln, die ins Log aufgenommen werden sollen, und die fuer die
	 * Bearbeitung der Anfrage benoetigte Zeit enthaelt.
	 * @param interaction Die urspruengliche Interaktion.
	 * @param addToLog Neues Wissen, was der Benutzer ins Log aufnehmen muss.
	 * @param processingTime Bearbeitungszeit in Millisekunden
	 */
	public ResultNotification( String interaction, List<IdAndFormula> addToLog, long processingTime ) {
		this.interaction = interaction;
		this.addToLog = addToLog;
		this.processingTime = processingTime;
	}
	
	/**
	 * Gibt die urspruengliche Interaktion des Benutzers zurueck.
	 * @return Urspruengliche Interaktion des Benutzers.
	 */
	public String getAnsweredInteraction() {
		return this.interaction;
	}
	
	/**
	 * Gibt die Liste an Formeln zurueck, die neu ins Wissen des Benutzers aufgenommen wurden.
	 * @return
	 */
	public List<IdAndFormula> getAddToLog() {
		return this.addToLog;
	}
	
	/**
	 * Gibt die Zeit in Millisekunden zurueck, die fuer die Bearbeitung der Anfrage benoetigt wurde.
	 * @return
	 */
	public long getProcessingTime() {
		return this.processingTime;
	}
	
	/**
	 * Setzt die Zeit, die fuer die Bearbeitung der Anfrage benoetigt wurde.
	 * @param processingTime Bearbeitungszeit in Millisekunden
	 */
	public void setProcessingTime( long processingTime ) {
		this.processingTime = processingTime;
	}
}
