package notification.serverToClient;

import java.util.EnumSet;

import notification.Notification;

import communication.CqeType;

/**
 * Diese Notification soll an die GUI uebergeben werden, wenn sich ein User versucht hat anzumelden.
 */
public class LoginAppNotification extends Notification {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2933401868799327918L;

	/**
	 * Wert, ob der Login erfolg war oder nicht. true = erfolgreicher login, false sonst.
	 */
	private boolean successful;
	
	/**
	 * Enthaelt die alle Rechte eines Benutzers. Die GUI prueft diese Rechte und zeigt entsprechend
	 * die richtigen Teile der Oberflaeche an. Selbst wenn die GUI sich nicht an die uebermittelten
	 * Rechte haelt, so prueft der Server bei jeder Anfrage, ob der Benutzer die noetigen Rechte
	 * auch besitzt.
	 */
	private EnumSet<CqeType.Right> rights;

	/**
	 * Erzeugt ein neues Object des Typs LoginNotification fuer einen _erfolgreichen_ Login.
	 * Deshalb muss neben einem Text, der dem Benutzer angezeigt wird, auch die UserRole angegeben werden.
	 * @param note Die Nachricht, die dem erfolgreich angemeldeten Benutzer angezeigt werden soll.
	 * @param role Die aktuelle Rolle des Benutzers.
	 */
	public LoginAppNotification(String note, EnumSet<CqeType.Right> rights) {
		super(note);
		this.successful = true;
		this.rights = rights;
	}
	
	/**
	 * Erzeugt eine LoginNotification fuer einen NICHT erfolgreichen Login.
	 * Die uebergebene Nachricht wird dem Benutzer als Fehlermeldung angezeigt.
	 * @param note Anzuzeigende Fehlermeldung.
	 */
	public LoginAppNotification(String note) {
		super(note);
		this.successful = false;
	}

	/**
	 * Gibt die Rechte des Benutzers zurueck. Die GUI kann dadurch die entsprechenden Oberflaechen anzeigen.
	 * @return Aktuelle Rechte des Benutzers.
	 */
	public EnumSet<CqeType.Right> getRights() {
		return this.rights;
	}
	
	/**
	 * Gibt zurueck, ob der Login erfolgreich war oder nicht. Bei einem erfolgreichen login ist die UserRole != null.
	 * @return true, falls der Login erfolgreich war, sonst false.
	 */
	public boolean getSuccessful() {
		return this.successful;
	}
}
