package notification.serverToClient;

import notification.Notification;

public class ExceptionNotification extends Notification {
	private static final long serialVersionUID = 9009761298282120038L;
	
	/**
	 * Typen fuer Exceptions.
	 */
	public final static int USERTOOSTUPID = 1;
	public final static int CRITICAL = 2;
	public final static int NONCRITICAL = 3;

	/**
	 * Exception, die aufgetreten ist. Muss nicht der Originalexception entsprechen,
	 * da z.B. SQLExceptions in allgemeinere DatabaseExceptions umgewandelt werden.
	 */
	private Exception exception;
	
	/**
	 * Typ der Exception. Wird von Application festgelegt. Fuer moegliche Typen siehe oben.
	 */
	private int type;
	
	public ExceptionNotification( Exception exception, int type ) {
		this.exception = exception;
		this.type = type;
	}
	
	public ExceptionNotification( Exception exception ) {
		this.exception = exception;
		this.type = NONCRITICAL;
	}
	
	public Exception getException() {
		return this.exception;
	}
	
	public int getExceptionType() {
		return this.type;
	}
}
