package notification.clientToServer;

import user.Role;
import notification.Notification;

public class EditUserNotification extends Notification {
	private static final long serialVersionUID = 527362684567785903L;

	// These are the things that die client can change.
	private int userId;
	private String username;
	private String password;
	private Role role;
	private String censor;
	
	public EditUserNotification( int userId, String username, String password, Role role, String censor ) {
		this.userId = userId;
		this.username = username;
		this.password = password;
		this.role = role;
		this.censor = censor;
	}

	/**
	 * @return the userId
	 */
	public int getUserId() {
		return userId;
	}

	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @return the role
	 */
	public Role getRole() {
		return role;
	}

	/**
	 * @deprecated
	 * @return the stateId
	 */
	public String getCensor() {
		return censor;
	}
}
