package notification.clientToServer;

import user.IdAndFormula;
import communication.CqeType;

import notification.Notification;

public class EditUserInformationNotification extends Notification {
	private static final long serialVersionUID = 3322632494961554454L;
	
	private int type;
	private int userId;
	private int formulaId;
	private String formula;
	private CqeType.PolicyType policyType;
	private CqeType.PolicyPreservation preservation;
	
	public EditUserInformationNotification( int userId, int type, int formulaId, String formula ) {
		this.userId = userId;
		this.type = type;
		this.formulaId = formulaId;
		this.formula = formula;
	}
	
	public EditUserInformationNotification( int userId, int formulaId, String formula, CqeType.PolicyType policyType, CqeType.PolicyPreservation preservation ) {
		this.type = IdAndFormula.TYPE_CONF_POL;
		this.userId = userId;
		this.formulaId = formulaId;
		this.formula = formula;
		this.policyType = policyType;
		this.preservation = preservation;
	}

	/**
	 * @return the type
	 */
	public int getType() {
		return type;
	}

	/**
	 * @return the formulaId
	 */
	public int getFormulaId() {
		return formulaId;
	}

	/**
	 * @return the formula
	 */
	public String getFormula() {
		return formula;
	}
	

	public CqeType.PolicyType getPolicyType() {
		return this.policyType;
	}
	
	public CqeType.PolicyPreservation getPreservation() {
		return this.preservation;
	}
	
	public int getUserId() {
		return this.userId;
	}
}
