package notification;

import java.io.Serializable;

/**
 * Allgemeine Oberklasse fuer Notifications. Speichert eine einfache Textnachricht.
 * @author Dirk Schalge
 *
 */
public abstract class Notification implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -2783773785530400252L;
	
	/**
	 * Fuer diese Notification gespeicherte Nachricht. Entspricht dem Klassennamen, falls keine Nachricht gespeichert wurde.
	 */
	private String text;

	/**
	 * Erzeugt eine Notification ohne speziellen Text. Die gespeicherte Nachricht wird auf den Klassennamen gesetzt.
	 */
	public Notification() {
		this.text = this.getClass().getName();
	}
	
	/**
	 * Erzeugt eine Notification mit dem uebergebenen Text.
	 * @param text Der zu speichernde Text. Wird in der toString()-Methode ausgegeben.
	 */
	public Notification(String text) {
		this.text = text;
	}
	
	/**
	 * Gibt die textuelle Repraesentation der Notification zurueck. Entspricht dem im Konstruktor
	 * angegebenen Text oder dem Klassenamen, wenn kein Text angegeben wurde.
	 */
	public String toString() {
		return this.text;
	}

}
