package notification;

import java.util.List;

/**
 * Kapselt einen Vector in einer Notification, z.B. fuer das Log und die potential secrets (Vector von Formula).
 * @author Dirk Schalge
 *
 * @param <T> Datentyp fuer den Vector, z.B. Formula.
 */
public class ListNotification<T> extends Notification {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4696462847140982479L;
	/**
	 * Der gespeicherte Vector vom Typ T (wird z.B. fuer Fomula-Vectoren benutzt).
	 */
	private List<T> vector;

	public ListNotification() {
		this.vector = null;
	}
	
	public ListNotification( List<T> vector ) {
		this.vector = vector;
	}
	/**
	 * Gibt den gespeicherten Vector zurueck.
	 * @return Der gespeicherte Vektor. Ist niemals null.
	 */
	public List<T> getVector() {
		return this.vector;
	}

	/**
	 * Setzt den gepeicherten Vector.
	 * @param vector Der neue Vector. Kann auch null sein, getVector() gibt dann einen leeren Vector zurueck.
	 */
	public void setVector(List<T> vector) {
		this.vector = vector;
	}
}
