package client.gui.usermanagement;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextField;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;


import server.parser.Formula;
import user.ConfidentialityPolicyItem;

import communication.CqeType;
import communication.CqeType.PolicyPreservation;
import communication.CqeType.PolicyType;
import exception.ParserException;

public class UserAddConfidentialityPolicyDialogPanel extends JPanel{

	private static final long serialVersionUID = -7307001585010327451L;
	private TextField txtFormula;
	private JComboBox cmbPolicyTypeBox;
	private JComboBox cmbPreservationTypeBox;

	public UserAddConfidentialityPolicyDialogPanel() {
		super();
		
		this.setBorder( BorderFactory.createEmptyBorder() );
		this.setLayout( new GridBagLayout() );
		GridBagConstraints constraints = new GridBagConstraints();
		constraints.gridwidth = 1;
		constraints.gridheight = 1;
		constraints.anchor = GridBagConstraints.WEST;
		
		// Formula
		JLabel lblFormula = new JLabel("Formula:");
		constraints.gridx = 0;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.NONE;
		this.add(lblFormula, constraints);
		txtFormula = new TextField(100);
		constraints.gridx = 1;
		constraints.gridy = 0;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		this.add(txtFormula, constraints);
		// Policy Type
		JLabel lblPolicyType = new JLabel("Policy Type:");
		constraints.gridx = 0;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.NONE;
		this.add(lblPolicyType, constraints);
		cmbPolicyTypeBox = new JComboBox( );
		// Combobox mit allen Policy Types ausser MIXED fuellen
		for (PolicyType value: CqeType.PolicyType.values()) {
			if (value == CqeType.PolicyType.MIXED) {
				continue;
			}
			cmbPolicyTypeBox.addItem(value);
		}
		
		
		constraints.gridx = 1;
		constraints.gridy = 1;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		this.add(cmbPolicyTypeBox, constraints);
		// Preservation Type
		JLabel lblPreservationType = new JLabel("Preservation Type:");
		constraints.gridx = 0;
		constraints.gridy = 2;
		constraints.fill = GridBagConstraints.NONE;
		this.add(lblPreservationType, constraints);
		cmbPreservationTypeBox = new JComboBox( CqeType.PolicyPreservation.values() );
		constraints.gridx = 1;
		constraints.gridy = 2;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		this.add(cmbPreservationTypeBox, constraints);
	}

	public ConfidentialityPolicyItem getResult() throws ParserException {
		Formula f = new Formula(txtFormula.getText());
		PolicyType type = (PolicyType) cmbPolicyTypeBox.getSelectedItem();
		PolicyPreservation preservation = (PolicyPreservation) cmbPreservationTypeBox.getSelectedItem();
		
		return new ConfidentialityPolicyItem(-1, f, type, preservation);
	}
}