package client.gui.mainwindow;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * GUI-Element: Zeigt einen Hilfetext an, je nachdem wo sich gerade die Maus
 * befindet.
 * @author schalge
 */
public class HelpPanel extends JPanel implements MouseListener {
	private static final long serialVersionUID = -489188421065488813L;
	
	private JLabel topicLabel = null;
    private JLabel textLabel = null;
    private String defaultText = "";

    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public HelpPanel() {
        BorderLayout layout = new BorderLayout();
        layout.setVgap( 20 );
        this.setLayout( layout );

        this.textLabel = new JLabel("");
        this.textLabel.setVerticalAlignment( JLabel.TOP );
        this.add( textLabel, BorderLayout.CENTER );
        
        this.topicLabel = new JLabel( "Hilfe" );
        this.topicLabel.setHorizontalAlignment( JLabel.CENTER );
        this.topicLabel.setFont( new Font("SansSerif", Font.BOLD, 14) );
        this.add( this.topicLabel, BorderLayout.NORTH );

        this.setPreferredSize( new Dimension(200, Integer.MAX_VALUE) );
        this.setMaximumSize( new Dimension(5000, Integer.MAX_VALUE) );
    }

    /**
     * Fuehrt keine Aktion aus (leere Methode).
     * @param e Ein Maus-Event.
     */
    public void mouseClicked(MouseEvent e) { }
    /**
     * Fuehrt keine Aktion aus (leere Methode).
     * @param e Ein Maus-Event.
     */
    public void mousePressed(MouseEvent e) { }
    /**
     * Fuehrt keine Aktion aus (leere Methode).
     * @param e Ein Maus-Event.
     */
    public void mouseReleased(MouseEvent e) { }

    /**
     * Setzt den aktuell angezeigten Hilfetext, je nachdem ueber welchem
     * GUI-Element sich die Maus gerade befindet.
     * @param e Maus-Aktion, die unter anderem das GUI-Element identifiziert.
     */
    public void mouseEntered(MouseEvent e) {
        this.textLabel.setText( "Onmouse-Over Text" );
    }

    /**
     * Loescht den Hilfetext beim Verlassen der Maus eines Elements mt Hilfetext.
     * @param e Maus-Aktion, die unter anderem das GUI-Element identifiziert.
     */
    public void mouseExited(MouseEvent e) {
        this.textLabel.setText( this.defaultText );
    }

}
