package client.gui.login;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import client.core.Client;



import exception.UnknownNotificationException;

/**
 * GUI-Element: Zeigt einen Kasten zur Auswahl einer Datenbank und zur
 * Eingabe eines Benutzernamen und Passwort. Durch den Login-Button wird die
 * Aktion login() in der Kontrollerklasse ausgefuehrt.
 * @author schalge
 */
public class LoginPanel extends JPanel implements ActionListener, KeyListener {
	private static final long serialVersionUID = 8590282198941308239L;
	
	private JPanel borderPanel = null;
    private JLabel dbmsLabel = null;
    private JLabel loginLabel = null;
    private JLabel pwLabel = null;
    
    
    private JComboBox dbmsCB = null;
    private JTextField loginField = null;
    private JPasswordField pwField = null;
    private JButton loginButton = null;


    /**
     * Erzeugt das beschriebene GUI-Element.
     */
    public LoginPanel( List<String> availableDBs ) {
        super();

        this.setBorder( BorderFactory.createEmptyBorder(10,20,10,20) );

        this.borderPanel = new JPanel();
        this.borderPanel.setBorder( BorderFactory.createTitledBorder("CIE Login") );

        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        c.weightx = 1.0;

        this.borderPanel.setLayout( grid );

        this.dbmsLabel = new JLabel("Database");
        this.addGridComponent(this.dbmsLabel,grid,c);
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        this.dbmsCB = new JComboBox();
        
        // Verfuegbare Datenbanken in die ComboBox eintragen.
        for( String id : availableDBs ) { 
        	this.dbmsCB.addItem( id );
        }
        
        
        this.addGridComponent(this.dbmsCB, grid, c);

        
        c.gridwidth = 1;    // reset to default
        this.loginLabel = new JLabel("Username");
        this.addGridComponent(this.loginLabel, grid, c);
        c.gridwidth = GridBagConstraints.REMAINDER; // end of row
        this.loginField = new JTextField(20);
        this.loginField.addKeyListener( this );
        this.addGridComponent(this.loginField, grid, c);

        c.gridwidth = 1;    // reset to default
        this.pwLabel = new JLabel("Password");
        this.addGridComponent(this.pwLabel, grid, c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        this.pwField = new JPasswordField(20);
        this.pwField.addKeyListener( this );
        this.addGridComponent(this.pwField, grid, c);

        c.gridwidth = GridBagConstraints.REMAINDER;
        this.loginButton = new JButton("Login");
        this.addGridComponent(this.loginButton, grid, c);

        this.loginButton.addActionListener( this );

        //Enter
        this.pwField.addActionListener(this);
        
        this.add ( this.borderPanel );
        this.setVisible(true);
    }

    /**
     * Hilfsmethode: Fuegt ein Element zum aktuellen Gridbag-Layout hinzu.
     * @param comp Komponente, die angezeigt werden soll.
     * @param gridbag Das aktuelle Gridbag.
     * @param c Constraint fuer das Gridbag (z.B. neue Zeile).
     */
    private void addGridComponent ( JComponent comp, GridBagLayout gridbag, GridBagConstraints c ) {
        gridbag.setConstraints(comp, c);
        this.borderPanel.add(comp);
    }

    /**
     * Behandelt das Druecken des Login-Buttons. Die ausgewaehlte Datenbank, der
     * eingegebene Benutzername und das Passwort werden an die GUI-Kontrollklasse
     * uebermittelt.
     * @param arg0 Durch das Druecken des Login-Button ausgeloeste Aktion.
     */
    public void actionPerformed(ActionEvent arg0) {
        try {
        	String password = new String(this.pwField.getPassword());
			Client.GUI.login( (String)this.dbmsCB.getSelectedItem(), this.loginField.getText(), password);
        
		} catch ( UnknownNotificationException exception ) {
			// TODO Auto-generated catch block
			exception.printStackTrace();
		} catch ( IOException exception ) {
			// FIXME error anzeigen
			exception.printStackTrace();
		}
    }
    
    public void toggleWrongLogin() {
    	this.loginField.setForeground( Color.RED );
    	this.pwField.setForeground( Color.RED );
    	this.repaint();
    }

	@Override
	public void keyPressed(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void keyReleased(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void keyTyped(KeyEvent arg0) {
		this.loginField.setForeground( Color.BLACK );
    	this.pwField.setForeground( Color.BLACK );
	}
}
