/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.tools.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class AppendingExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_OVERWRITE_MODE = "overwrite_mode";
    public static final String[] OVERWRITE_MODES = new String[]{"none", "overwrite first, append then", "overwrite", "append"};
    public static final int OVERWRITE_MODE_NONE = 0;
    public static final int OVERWRITE_MODE_OVERWRITE_FIRST = 1;
    public static final int OVERWRITE_MODE_OVERWRITE = 2;
    public static final int OVERWRITE_MODE_APPEND = 3;

    public AppendingExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    protected boolean shouldAppend(File dataFile) throws UndefinedParameterError, UserError {
        int overwriteMode = this.getParameterAsInt(PARAMETER_OVERWRITE_MODE);
        boolean append = false;
        switch (overwriteMode) {
            case 0: {
                if (dataFile.exists()) {
                    throw new UserError((Operator)this, 100);
                }
                append = false;
                break;
            }
            case 2: {
                if (dataFile.exists()) {
                    this.getLogger().info("File " + dataFile + " already exists. Overwriting...");
                }
                append = false;
                break;
            }
            case 3: {
                if (dataFile.exists()) {
                    this.getLogger().info("File " + dataFile + " already exists. Appending...");
                }
                append = true;
                break;
            }
            default: {
                if (this.getApplyCount() <= 1) {
                    if (dataFile.exists()) {
                        this.getLogger().info("File " + dataFile + " already exists. Overwriting this time...");
                    }
                    append = false;
                    break;
                }
                if (dataFile.exists()) {
                    this.getLogger().info("File " + dataFile + " already exists. Appending...");
                }
                append = true;
            }
        }
        return append;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_OVERWRITE_MODE, "Indicates if an existing table should be overwritten or if data should be appended.", OVERWRITE_MODES, 1));
        types.addAll(super.getParameterTypes());
        return types;
    }
}

