/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.htmltools;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;

public class CountingMultipartEntity
extends MultipartEntity {
    private final ProgressListener listener;

    public CountingMultipartEntity(ProgressListener listener) {
        this.listener = listener;
    }

    public CountingMultipartEntity(HttpMultipartMode mode, ProgressListener listener) {
        super(mode);
        this.listener = listener;
    }

    public CountingMultipartEntity(HttpMultipartMode mode, String boundary, Charset charset, ProgressListener listener) {
        super(mode, boundary, charset);
        this.listener = listener;
    }

    @Override
    public void addPart(FormBodyPart bodyPart) {
        super.addPart(bodyPart);
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        super.writeTo(new CountingOutputStream(outstream, this.listener, this.getContentLength()));
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private final ProgressListener listener;
        private long transferred;
        private long content_length;

        public CountingOutputStream(OutputStream out, ProgressListener listener, long content_length) {
            super(out);
            this.listener = listener;
            this.transferred = 0L;
            this.content_length = content_length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            this.listener.transferred(this.transferred, this.content_length);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            this.listener.transferred(this.transferred, this.content_length);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1, long var3);
    }
}

