package de.dwds.ddc.client;

import org.json.*;

/** base class for query responses from ddc server, used by DDCClient */
public class DDCJsonArray {
	//-----------------------------------------------------------------
	// properties (public, because private data is annoying)
	
	/** underlying JSONArray: public, because private data is annoying */
	public JSONArray obj;
	
	//-----------------------------------------------------------------
	// constructors etc
	
	/** default constructor */
	DDCJsonArray()
	{
		obj = null;
	}
	
	/** constructor from json string */
	DDCJsonArray(String jsonStr) throws JSONException
	{ this.fromJson(jsonStr); }

	/** constructor from json object*/
	DDCJsonArray(JSONArray jsonObj) throws JSONException
	{ this.fromJson(jsonObj); }

	//-----------------------------------------------------------------
	// parsing

	/** populate object by parsing ddc-2.x json response string */
	public void fromJson(String jsonStr) throws JSONException
	{ fromJson(new JSONArray(jsonStr)); }

	/** populate object by parsing ddc-2.x json response object;
	 *  really just sets obj=jsonObj.
	 *  child classes should override this method.
	 */
	public void fromJson(JSONArray jsonObj) throws JSONException
	{ obj = jsonObj; }
			
	// -----------------------------------------------------------------
	// stringification
	/** stringification just wraps obj.toString() */
	public String toString()
	{ return obj.toString(); }
}
