/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;

public class ExonWelchTest
extends AbstractWeighting {
    public static final String PARAMETER_BH_KORREKTUR = "Benjamini-Hochberg-Adjustment";

    public ExonWelchTest(OperatorDescription operatordescription) {
        super(operatordescription);
    }

    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        this.setParameter("normalize_weights", "false");
        this.setParameter("sort_weights", "false");
        boolean outputBH = this.getParameterAsBoolean(PARAMETER_BH_KORREKTUR);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.getMapping().getValues().size() != 2) {
            throw new OperatorException("Welch-test only applicable for two-class problems.");
        }
        AttributeWeights pValueWeights = new AttributeWeights(exampleSet);
        String[] attributeNames = new String[pValueWeights.getAttributeNames().size()];
        attributeNames = pValueWeights.getAttributeNames().toArray(attributeNames);
        int d = exampleSet.getAttributes().size();
        int n = exampleSet.size();
        double[] labelsExamples = new double[n];
        double[] sumX = new double[d];
        double[] sumY = new double[d];
        double[] sumXX = new double[d];
        double[] sumYY = new double[d];
        int i = 0;
        int nX = 0;
        int nY = 0;
        int posLabelIndex = label.getMapping().getPositiveIndex();
        Iterator iterator = exampleSet.iterator();
        while (iterator.hasNext()) {
            double label2;
            labelsExamples[i] = label2 = ((Example)iterator.next()).getLabel();
            if (label2 == (double)posLabelIndex) {
                ++nX;
            } else {
                ++nY;
            }
            ++i;
        }
        if (nX == 0) {
            throw new UserError((Operator)this, 105, new Object[]{"Positive class contains no examples."});
        }
        if (nY == 0) {
            throw new UserError((Operator)this, 105, new Object[]{"Negative class contains no examples."});
        }
        for (i = 0; i < d; ++i) {
            sumX[i] = 0.0;
            sumY[i] = 0.0;
            sumXX[i] = 0.0;
            sumYY[i] = 0.0;
        }
        int j = 0;
        for (Example example : exampleSet) {
            i = 0;
            for (Attribute att : exampleSet.getAttributes()) {
                double value = example.getValue(att);
                if (labelsExamples[j] == (double)posLabelIndex) {
                    int n2 = i;
                    sumX[n2] = sumX[n2] + value;
                    int n3 = i;
                    sumXX[n3] = sumXX[n3] + value * value;
                } else {
                    int n4 = i;
                    sumY[n4] = sumY[n4] + value;
                    int n5 = i;
                    sumYY[n5] = sumYY[n5] + value * value;
                }
                ++i;
            }
            ++j;
        }
        i = 0;
        for (Attribute att : exampleSet.getAttributes()) {
            double cum2;
            double cum1;
            double varX = (sumXX[i] - sumX[i] * sumX[i] / (double)nX) / (double)(nX - 1);
            double varY = (sumYY[i] - sumY[i] * sumY[i] / (double)nY) / (double)(nY - 1);
            double meanX = sumX[i] / (double)nX;
            double meanY = sumY[i] / (double)nY;
            double t = Math.abs((meanX - meanY) / Math.sqrt(varX / (double)nX + varX / (double)nY));
            double c = varX / (double)nX / (varX / (double)nX + varY / (double)nY);
            double v = 1.0 / (c * c / ((double)nX - 1.0) + (1.0 - c) * (1.0 - c) / ((double)nY - 1.0));
            TDistributionImpl dist = nX != nY ? new TDistributionImpl((int)v) : new TDistributionImpl(v);
            try {
                cum1 = dist.cumulativeProbability(t);
            }
            catch (MathException e) {
                cum1 = 0.0;
                e.printStackTrace();
            }
            try {
                cum2 = dist.cumulativeProbability(-t);
            }
            catch (MathException e) {
                cum2 = 0.0;
                e.printStackTrace();
            }
            double p = 1.0 - (cum1 - cum2);
            pValueWeights.setWeight(att.getName(), p);
            ++i;
        }
        if (outputBH) {
            String[] attributeNames2 = new String[pValueWeights.getAttributeNames().size()];
            attributeNames2 = pValueWeights.getAttributeNames().toArray(attributeNames);
            int sizeWeights = pValueWeights.size();
            pValueWeights.sortByWeight(attributeNames2, 1, 0);
            for (int k = 1; k < attributeNames2.length; ++k) {
                double pValue = pValueWeights.getWeight(attributeNames2[k]);
                double newpValue = pValue * (double)sizeWeights / (double)(k + 1);
                pValueWeights.setWeight(attributeNames2[k], newpValue);
            }
        }
        pValueWeights.setSource(this.getName());
        return pValueWeights;
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>(0);
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_LABEL || capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return capability != OperatorCapability.NUMERICAL_LABEL && capability != OperatorCapability.BINOMINAL_ATTRIBUTES && capability != OperatorCapability.POLYNOMINAL_LABEL && capability != OperatorCapability.POLYNOMINAL_ATTRIBUTES;
    }
}

