/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.distribution.TDistributionImpl;

public class ExonChooseTest
extends AbstractWeighting {
    public static final String PARAMETER_SIGNIFICANCE = "significance";

    public ExonChooseTest(OperatorDescription operatordescription) {
        super(operatordescription);
    }

    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        this.setParameter("normalize_weights", "false");
        this.setParameter("sort_weights", "false");
        double significance = this.getParameterAsDouble(PARAMETER_SIGNIFICANCE);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label.getMapping().getValues().size() != 2) {
            throw new OperatorException("Welch-test only applicable for two-class problems.");
        }
        AttributeWeights pValueWeights = new AttributeWeights(exampleSet);
        String[] attributeNames = new String[pValueWeights.getAttributeNames().size()];
        attributeNames = pValueWeights.getAttributeNames().toArray(attributeNames);
        int d = exampleSet.getAttributes().size();
        int n = exampleSet.size();
        double[] labelsExamples = new double[n];
        double[] sumX = new double[d];
        double[] sumY = new double[d];
        double[] sumXX = new double[d];
        double[] sumYY = new double[d];
        int i = 0;
        double nX = 0.0;
        double nY = 0.0;
        int posLabelIndex = label.getMapping().getPositiveIndex();
        Iterator iterator = exampleSet.iterator();
        while (iterator.hasNext()) {
            double label2;
            labelsExamples[i] = label2 = ((Example)iterator.next()).getLabel();
            if (label2 == (double)posLabelIndex) {
                nX += 1.0;
            } else {
                nY += 1.0;
            }
            ++i;
        }
        if (nX == 0.0) {
            throw new UserError((Operator)this, 105, new Object[]{"Positive class contains no examples."});
        }
        if (nY == 0.0) {
            throw new UserError((Operator)this, 105, new Object[]{"Negative class contains no examples."});
        }
        for (i = 0; i < d; ++i) {
            sumX[i] = 0.0;
            sumY[i] = 0.0;
            sumXX[i] = 0.0;
            sumYY[i] = 0.0;
        }
        int j = 0;
        for (Example example : exampleSet) {
            i = 0;
            for (Attribute att : exampleSet.getAttributes()) {
                double value = example.getValue(att);
                if (labelsExamples[j] == (double)posLabelIndex) {
                    int n2 = i;
                    sumX[n2] = sumX[n2] + value;
                    int n3 = i;
                    sumXX[n3] = sumXX[n3] + value * value;
                } else {
                    int n4 = i;
                    sumY[n4] = sumY[n4] + value;
                    int n5 = i;
                    sumYY[n5] = sumYY[n5] + value * value;
                }
                ++i;
            }
            ++j;
        }
        double denomT = Math.sqrt(nX * nY / (nX + nY));
        FDistributionImpl fDistX = new FDistributionImpl(nX, nY);
        FDistributionImpl fDistY = new FDistributionImpl(nY, nX);
        int countT = 0;
        int countWelch = 0;
        i = 0;
        for (Attribute att : exampleSet.getAttributes()) {
            double cum2;
            TDistributionImpl dist;
            double v;
            double t;
            double cum1;
            FDistributionImpl fDist;
            double f;
            double varX = (sumXX[i] - sumX[i] * sumX[i] / nX) / (nX - 1.0);
            double varY = (sumYY[i] - sumY[i] * sumY[i] / nY) / (nY - 1.0);
            double meanX = sumX[i] / nX;
            double meanY = sumY[i] / nY;
            if (varX > varY) {
                f = varX / varY;
                fDist = fDistX;
            } else {
                f = varY / varX;
                fDist = fDistY;
            }
            try {
                cum1 = fDist.cumulativeProbability(f);
            }
            catch (MathException e) {
                cum1 = 0.0;
                e.printStackTrace();
            }
            double p = 1.0 - cum1;
            if (p <= significance) {
                ++countWelch;
                t = Math.abs((meanX - meanY) / Math.sqrt(varX / nX + varX / nY));
                double c = varX / nX / (varX / nX + varY / nY);
                v = 1.0 / (c * c / (nX - 1.0) + (1.0 - c) * (1.0 - c) / (nY - 1.0));
                dist = nX != nY ? new TDistributionImpl((int)v) : new TDistributionImpl(v);
            } else {
                ++countT;
                v = nX + nY - 2.0;
                double s = Math.sqrt((sumXX[i] - sumX[i] * sumX[i] / nX + (sumYY[i] - sumY[i] * sumY[i] / nY)) / v);
                t = Math.abs((meanX - meanY) / s * denomT);
                dist = new TDistributionImpl(v);
            }
            try {
                cum1 = dist.cumulativeProbability(t);
            }
            catch (MathException e) {
                cum1 = 0.0;
                e.printStackTrace();
            }
            try {
                cum2 = dist.cumulativeProbability(-t);
            }
            catch (MathException e) {
                cum2 = 0.0;
                e.printStackTrace();
            }
            p = 1.0 - (cum1 - cum2);
            pValueWeights.setWeight(att.getName(), p);
            ++i;
        }
        pValueWeights.getAnnotations().put("Welch-tested", String.valueOf(countWelch));
        pValueWeights.getAnnotations().put("t-tested", String.valueOf(countT));
        pValueWeights.setSource(this.getName());
        return pValueWeights;
    }

    public List<ParameterType> getParameterTypes() {
        ArrayList<ParameterType> types = new ArrayList<ParameterType>(1);
        types.add((ParameterType)new ParameterTypeDouble(PARAMETER_SIGNIFICANCE, "Significance level for F-test", Double.MIN_NORMAL, 1.0, 0.05));
        return types;
    }

    public boolean supportsCapability(OperatorCapability capability) {
        if (capability == OperatorCapability.BINOMINAL_LABEL || capability == OperatorCapability.NUMERICAL_ATTRIBUTES) {
            return true;
        }
        return capability != OperatorCapability.NUMERICAL_LABEL && capability != OperatorCapability.BINOMINAL_ATTRIBUTES && capability != OperatorCapability.POLYNOMINAL_LABEL && capability != OperatorCapability.POLYNOMINAL_ATTRIBUTES;
    }
}

