/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.mfs.AbstractWeightingChain;
import com.rapidminer.operator.mfs.Util;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;
import java.util.Random;

public class EnsembleFeatureSelection
extends AbstractWeightingChain {
    protected final OutputPort robustnessOutput = (OutputPort)this.getOutputPorts().createPort("robustness");
    public static final String PARAMETER_METHOD = "method";
    public static final String[] METHODS = new String[]{"top-k", "geq_w", "accumulate_weights"};
    public static final int METHOD_TOPK = 0;
    public static final int METHOD_WEIGHTS = 1;
    public static final int METHOD_ACCUMULATE_WEIGHTS = 2;
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_MIN_ROUNDS = "min_rounds";
    public static final String PARAMETER_W = "w";
    public static final String PARAMETER_BOOTSTRAP_OR_SUBSETS = "subsets_or_bootstrap";
    public static final String[] BOOTSTRAP_OR_SUBSETS = new String[]{"subsets", "bootstrap"};
    public static final int SUBSET = 0;
    public static final int BOOTSTRAP = 1;
    public static final String PARAMETER_BOOTSTRAP_RATIO = "ratio";
    public static final String PARAMETER_ENSEMBLE_SIZE = "ensemble_size";
    public static final String PARAMETER_NORMALIZE = "normalize_weights";
    public static final String PARAMETER_ABSOLUTE_WEIGHTS = "use_absolute_weights";
    public static final String PARAMETER_LEAVE_ONE_OUT = "leave_one_out";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private double robustness = 0.0;

    public EnsembleFeatureSelection(OperatorDescription description) {
        super(description);
        this.addValue((Value)new ValueDouble("robustness", "Robustness of the inner Feature Selection operator"){

            public double getDoubleValue() {
                return EnsembleFeatureSelection.this.robustness;
            }
        });
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.robustnessOutput, PerformanceVector.class));
    }

    @Override
    public void doWork() throws OperatorException {
        this.iteration = 0;
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        boolean doTheBootstrap = this.getParameterAsInt(PARAMETER_BOOTSTRAP_OR_SUBSETS) == 1;
        int method = this.getParameterAsInt(PARAMETER_METHOD);
        int samplingType = this.getParameterAsInt(PARAMETER_SAMPLING_TYPE);
        int ensembleSize = !doTheBootstrap && this.getParameterAsBoolean(PARAMETER_LEAVE_ONE_OUT) ? inputSet.size() : this.getParameterAsInt(PARAMETER_ENSEMBLE_SIZE);
        this.getLogger().finer("Starting " + ensembleSize + "-fold ensemble feature selection");
        int minRounds = this.getParameterAsInt(PARAMETER_MIN_ROUNDS);
        if (minRounds > ensembleSize) {
            minRounds = ensembleSize;
            this.getLogger().finer("Setting the minimum number of top-ranked rounds to number of rounds.");
        }
        AttributeWeights[] weights = new AttributeWeights[ensembleSize];
        if (doTheBootstrap) {
            RandomGenerator random = RandomGenerator.getRandomGenerator((Operator)this);
            this.iteration = 0;
            while (this.iteration < ensembleSize) {
                this.inApplyLoop();
                int[] mapping = MappedExampleSet.createBootstrappingMapping((ExampleSet)inputSet, (int)((int)Math.round((double)inputSet.size() * this.getParameterAsDouble(PARAMETER_BOOTSTRAP_RATIO))), (Random)random);
                MappedExampleSet bootstrappedExampleSet = new MappedExampleSet(inputSet, mapping, true);
                this.weightingProcessExampleSetOutput.deliver((IOObject)bootstrappedExampleSet);
                this.getSubprocess(0).execute();
                weights[this.iteration] = (AttributeWeights)this.weightingProcessWeightsInput.getData();
                ++this.iteration;
            }
        } else {
            SplittedExampleSet splitES = new SplittedExampleSet(inputSet, ensembleSize, samplingType, this.getParameterAsBoolean("use_local_random_seed"), this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
            this.iteration = 0;
            while (this.iteration < ensembleSize) {
                this.inApplyLoop();
                splitES.selectAllSubsetsBut(this.iteration);
                this.weightingProcessExampleSetOutput.deliver((IOObject)splitES);
                this.getSubprocess(0).execute();
                weights[this.iteration] = (AttributeWeights)this.weightingProcessWeightsInput.getData();
                ++this.iteration;
            }
        }
        AttributeWeights resWeights = new AttributeWeights(inputSet);
        String[] attributeNames = new String[resWeights.getAttributeNames().size()];
        attributeNames = resWeights.getAttributeNames().toArray(attributeNames);
        int k = this.getParameterAsInt(PARAMETER_K);
        double w = this.getParameterAsDouble(PARAMETER_W);
        for (int j = 0; j < attributeNames.length; ++j) {
            resWeights.setWeight(attributeNames[j], 0.0);
        }
        double kevin = 0.0;
        for (int i = 0; i < ensembleSize; ++i) {
            if (weights[i].getSize() >= attributeNames.length) continue;
            AttributeWeights temp_w = new AttributeWeights(inputSet);
            for (String attName : attributeNames) {
                kevin = weights[i].getWeight(attName);
                if (Double.isNaN(kevin)) {
                    temp_w.setWeight(attName, 0.0);
                    continue;
                }
                temp_w.setWeight(attName, kevin);
            }
            weights[i] = temp_w;
        }
        boolean absoluteWeights = this.getParameterAsBoolean(PARAMETER_ABSOLUTE_WEIGHTS);
        int comparatorType = absoluteWeights ? 1 : 0;
        for (int i = 0; i < ensembleSize; ++i) {
            int j;
            if (method == 0) {
                weights[i].sortByWeight(attributeNames, -1, comparatorType);
                for (j = 0; j < k && j < attributeNames.length; ++j) {
                    resWeights.setWeight(attributeNames[j], resWeights.getWeight(attributeNames[j]) + 1.0);
                    weights[i].setWeight(attributeNames[j], 1.0);
                }
                for (j = k; j < attributeNames.length; ++j) {
                    weights[i].setWeight(attributeNames[j], 0.0);
                }
                continue;
            }
            if (method == 1) {
                for (j = 0; j < attributeNames.length; ++j) {
                    if (!absoluteWeights && weights[i].getWeight(attributeNames[j]) >= w || absoluteWeights && Math.abs(weights[i].getWeight(attributeNames[j])) >= w) {
                        weights[i].setWeight(attributeNames[j], 1.0);
                        resWeights.setWeight(attributeNames[j], resWeights.getWeight(attributeNames[j]) + 1.0);
                        continue;
                    }
                    weights[i].setWeight(attributeNames[j], 0.0);
                }
                continue;
            }
            if (method != 2) continue;
            for (j = 0; j < attributeNames.length; ++j) {
                resWeights.setWeight(attributeNames[j], resWeights.getWeight(attributeNames[j]) + weights[i].getWeight(attributeNames[j]));
            }
        }
        if (method == 0) {
            int j;
            if (minRounds > 0) {
                for (j = 0; j < attributeNames.length; ++j) {
                    if (!(resWeights.getWeight(attributeNames[j]) < (double)minRounds)) continue;
                    resWeights.setWeight(attributeNames[j], 0.0);
                }
            } else {
                resWeights.sortByWeight(attributeNames, -1, comparatorType);
                for (j = 0; j < k && j < attributeNames.length; ++j) {
                    resWeights.setWeight(attributeNames[j], 1.0);
                }
                for (j = k; j < attributeNames.length; ++j) {
                    resWeights.setWeight(attributeNames[j], 0.0);
                }
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE)) {
            resWeights.normalize();
        }
        this.robustness = Util.averageJaccard(attributeNames, weights, ensembleSize);
        this.getLogger().finest("Robustness of the ensemble feature selection: " + this.robustness);
        PerformanceVector pvector = new PerformanceVector();
        EstimatedPerformance criterion = new EstimatedPerformance("Robustness", this.robustness, attributeNames.length, false);
        pvector.addCriterion((PerformanceCriterion)criterion);
        pvector.setMainCriterionName("Robustness");
        this.weightsOutput.deliver((IOObject)resWeights);
        this.exampleSetOutput.deliver((IOObject)inputSet);
        this.robustnessOutput.deliver((IOObject)pvector);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_ENSEMBLE_SIZE, "Ensemble size.", 2, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_METHOD, "Select the top-k attributes or those with a weight above threshold w", METHODS, 0);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_K, "Parameter k, as in top-k", 0, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, METHODS, false, new int[]{0}));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MIN_ROUNDS, "The minimum number of rounds an attribute has to be top ranked, to be included in the final subset. 0 = no constraint.", 0, Integer.MAX_VALUE, 0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, METHODS, false, new int[]{0}));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_W, "Parameter w, as in weights geq w", Double.MIN_VALUE, Double.MAX_VALUE, 0.5);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, METHODS, false, new int[]{1}));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_ABSOLUTE_WEIGHTS, "Use absolute weights", false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_NORMALIZE, "Normalize weights", true);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_BOOTSTRAP_OR_SUBSETS, "Use subsets or bootstraps to generate ensemble diversity.", BOOTSTRAP_OR_SUBSETS, 0));
        type = new ParameterTypeDouble(PARAMETER_BOOTSTRAP_RATIO, "Relative size of the bootstrapped example sets.", 1.0E-4, 1.0, 1.0);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{1}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_LEAVE_ONE_OUT, "Set the number of validations to the number of examples. If set to true, number_of_validations is ignored", false);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{0}));
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{0}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LEAVE_ONE_OUT, false, false));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_BOOTSTRAP_OR_SUBSETS, BOOTSTRAP_OR_SUBSETS, false, new int[]{0}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LEAVE_ONE_OUT, false, false));
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_SAMPLING_TYPE, SplittedExampleSet.SAMPLING_NAMES, false, new int[]{1, 2}));
        types.add(type);
        return types;
    }

    public static enum Method {
        Subset,
        Average;

    }
}

