/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.mfs;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;

public class BenjaminiHochbergCorrection
extends Operator {
    private final InputPort weightsInput = this.getInputPorts().createPort("weights", AttributeWeights.class);
    private final OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");
    public final String PARAMETER_SIG_BEFORE = "initial_significance";
    public final String PARAMETER_SIG_DESIRED = "desired_significance";

    public BenjaminiHochbergCorrection(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        AttributeWeights pValueWeights = (AttributeWeights)this.weightsInput.getData(AttributeWeights.class);
        int p = pValueWeights.size();
        String[] attributeNames = new String[p];
        attributeNames = pValueWeights.getAttributeNames().toArray(attributeNames);
        pValueWeights.sortByWeight(attributeNames, 1, 0);
        double pValue = 0.0;
        double M = p;
        double j = 1.0;
        pValue = pValueWeights.getWeight(attributeNames[p - 1]);
        for (int i = p - 2; i >= 0; --i) {
            pValue = Math.min(pValue, M / (M - j) * pValueWeights.getWeight(attributeNames[i]));
            pValueWeights.setWeight(attributeNames[i], pValue);
            j += 1.0;
        }
        this.weightsOutput.deliver((IOObject)pValueWeights);
    }
}

