/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.lasso;

import com.rapidminer.operator.lasso.LARSModel;
import com.rapidminer.report.Renderable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Paint;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LARSVisualization
extends JPanel
implements Renderable {
    private static final long serialVersionUID = 8082780576642978018L;
    private LARSModel model;
    private ChartPanel frame;
    private JLabel label;

    public LARSVisualization(LARSModel m) {
        this.model = m;
        this.setLayout(new BorderLayout());
        int numSeries = this.model.getBeta().get(0).getDimension();
        int lenSeries = this.model.getBeta().size();
        double[] lenB = new double[lenSeries];
        for (int i = 0; i < lenSeries; ++i) {
            lenB[i] = this.model.getBeta().get(i).getL1Norm();
        }
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        for (int j = 0; j < numSeries; ++j) {
            XYSeries series = new XYSeries((Comparable)((Object)this.model.getWeights().getAveragable(j).getName()));
            boolean isZero = true;
            for (int i = 0; i < lenSeries; ++i) {
                double tmp = this.model.getBeta().get(i).getEntry(j);
                series.add(lenB[i], tmp);
                if (tmp == 0.0) continue;
                isZero = false;
            }
            if (!isZero) {
                xyDataset.addSeries(series);
                continue;
            }
            series.clear();
        }
        String title = "";
        title = this.model.lasso ? "Least Absolute Selection and Shrinkage Operator" : "Least Angle Regression";
        JFreeChart chart = ChartFactory.createXYLineChart((String)title, (String)"|beta|", (String)"beta_i", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.setAntiAlias(true);
        chart.setBackgroundPaint((Paint)Color.white);
        if (this.model.lasso && this.model.threshold != 0.0) {
            double y1 = xyDataset.getRangeLowerBound(true);
            double y2 = xyDataset.getRangeUpperBound(true);
            XYSeries seriesT = new XYSeries((Comparable)((Object)"Threshold"));
            seriesT.add(this.model.threshold, y1);
            seriesT.add(this.model.threshold, y2);
            xyDataset.addSeries(seriesT);
        }
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setBaseShapesFilled(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        this.frame = new ChartPanel(chart);
        this.frame.setBackground(Color.WHITE);
        this.frame.setPreferredSize(this.getPreferredSize());
        this.frame.setFillZoomRectangle(true);
        this.add((Component)this.frame);
    }

    public void finishRendering() {
    }

    public int getRenderHeight(int preferredHeight) {
        return this.frame.getHeight();
    }

    public int getRenderWidth(int preferredWidth) {
        return this.frame.getWidth();
    }

    public void prepareRendering() {
        this.label = new JLabel("Test");
    }

    public void render(Graphics graphics, int width, int height) {
        this.add(this.label);
    }
}

