/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.lasso;

import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.lasso.LARSModel;
import com.rapidminer.operator.lasso.LARSVisualization;
import com.rapidminer.report.Reportable;
import java.awt.Component;

public class LARSRenderer
extends AbstractRenderer {
    public static final String PARAMETER_PLOTTER = "plotter";
    private LARSModel model;
    private LARSVisualization vis;
    private ExtendedJScrollPane pane;

    public String getName() {
        if (this.model == null) {
            return "Empty model";
        }
        if (this.model.lasso) {
            return "LASSO iterations";
        }
        return "LARS iterations";
    }

    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        if (!(renderable instanceof LARSModel)) {
            renderable = null;
        }
        this.model = (LARSModel)((Object)renderable);
        this.vis = new LARSVisualization(this.model);
        this.pane = new ExtendedJScrollPane((Component)this.vis);
        return this.pane;
    }

    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        if (!(renderable instanceof LARSModel)) {
            renderable = null;
        }
        if (this.model == null) {
            this.model = (LARSModel)((Object)renderable);
        }
        if (this.vis == null) {
            this.vis = new LARSVisualization(this.model);
        }
        if (this.vis != null) {
            this.vis.setSize(width, height);
        }
        return this.vis;
    }
}

