/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.fcbf;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.fcbf.FCBFAttributeLabel;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class FCBFAttribute
extends FCBFAttributeLabel
implements Comparable<FCBFAttribute> {
    protected double classSU;

    public FCBFAttribute(Attribute attribute, Vector<Integer> discretizedValues, FCBFAttributeLabel fcbfAttributeLabel) {
        super(attribute, discretizedValues);
        this.classSU = this.calculateMutualSU(fcbfAttributeLabel);
    }

    public double calculateMutualSU(FCBFAttributeLabel other) {
        HashMap posteriorPMF;
        int y;
        HashMap<Integer, HashMap> mutualPMF = new HashMap<Integer, HashMap>();
        HashMap<Integer, Integer> countOccurrences = new HashMap<Integer, Integer>();
        int discretizedValuesSize = this.discretizedValues.size();
        for (int i = 0; i < discretizedValuesSize; ++i) {
            int x = (Integer)this.discretizedValues.get(i);
            y = other.discretizedValues.get(i);
            if (mutualPMF.containsKey(y)) {
                posteriorPMF = (HashMap)mutualPMF.get(y);
                if (posteriorPMF.containsKey(x)) {
                    posteriorPMF.put(x, (Double)posteriorPMF.get(x) + 1.0);
                } else {
                    posteriorPMF.put(x, 1.0);
                }
                mutualPMF.put(y, posteriorPMF);
                countOccurrences.put(y, (Integer)countOccurrences.get(y) + 1);
                continue;
            }
            posteriorPMF = new HashMap();
            posteriorPMF.put(x, 1.0);
            mutualPMF.put(y, posteriorPMF);
            countOccurrences.put(y, 1);
        }
        double mutualEntropy = 0.0;
        for (Map.Entry entry : mutualPMF.entrySet()) {
            y = (Integer)entry.getKey();
            posteriorPMF = (HashMap)entry.getValue();
            for (Map.Entry posteriorEntry : posteriorPMF.entrySet()) {
                double value = (Double)posteriorEntry.getValue() / (double)((Integer)countOccurrences.get(y)).intValue();
                mutualEntropy -= other.pmf.get(y) * value * Math.log10(value) / Math.log10(2.0);
            }
        }
        double informationGain = this.entropy - mutualEntropy;
        double mutualSU = this.entropy + other.entropy != 0.0 ? 2.0 * informationGain / (this.entropy + other.entropy) : 1.0;
        return mutualSU;
    }

    public double getClassSU() {
        return this.classSU;
    }

    @Override
    public int compareTo(FCBFAttribute other) {
        if (this.classSU < other.classSU) {
            return 1;
        }
        if (this.classSU == other.classSU) {
            return 0;
        }
        return -1;
    }
}

