/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.experiments;

import java.util.ArrayList;
import timeseriesclustering.DTW;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.TimeSeriesClustering;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.EuclidianAveraging;
import timeseriesclustering.averaging.FastShapeBasedAveraging;
import timeseriesclustering.averaging.FixpointAveraging;
import timeseriesclustering.averaging.ProjectionAveraging;
import timeseriesclustering.averaging.ShapeBasedAveraging;
import timeseriesclustering.dataimport.CylinderBellFunnel;
import timeseriesclustering.experiments.SVGOutput;

public class CentroidComparison {
    public static void main(String[] args) {
        CentroidComparison.idealSetup();
        CentroidComparison.exdealSetup();
    }

    private static void idealSetup() {
        ArrayList<Double[]> cluster1 = new ArrayList<Double[]>(100);
        ArrayList<Double[]> cluster2 = new ArrayList<Double[]>(100);
        ArrayList<Double[]> cluster3 = new ArrayList<Double[]>(100);
        for (int i = 0; i < 100; ++i) {
            Double[] ts3 = CylinderBellFunnel.funnel();
            Double[] ts2 = CylinderBellFunnel.bell();
            Double[] ts1 = CylinderBellFunnel.cylinder();
            cluster1.add(TimeSeriesClustering.normalize(ts1));
            cluster2.add(TimeSeriesClustering.normalize(ts2));
            cluster3.add(TimeSeriesClustering.normalize(ts3));
        }
        SakoeChibaBand con = new SakoeChibaBand(64);
        int name = 0;
        for (AveragingTechnique t : new AveragingTechnique[]{new EuclidianAveraging(), new ProjectionAveraging(), new FixpointAveraging(), new ShapeBasedAveraging(), new FastShapeBasedAveraging()}) {
            for (int j = 0; j < 3; ++j) {
                int n = 1;
                if (t instanceof ProjectionAveraging || t instanceof FixpointAveraging || t instanceof FastShapeBasedAveraging) {
                    n = 100;
                }
                double totalSum = 0.0;
                double min = Double.POSITIVE_INFINITY;
                double max = 0.0;
                double dtwTotalSum = 0.0;
                double dtwMin = Double.POSITIVE_INFINITY;
                double dtwMax = 0.0;
                for (int i = 0; i < n; ++i) {
                    SVGOutput o = new SVGOutput();
                    DTW.count = 0.0;
                    Double[] ts = null;
                    double sum = 0.0;
                    if (j == 0) {
                        ts = t.average(cluster1, (Double[])cluster1.get(i), con);
                        for (Double[] a : cluster1) {
                            sum += DTW.dtw((Double[])a, (Double[])ts, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                        }
                    }
                    if (j == 1) {
                        ts = t.average(cluster2, (Double[])cluster2.get(i), con);
                        for (Double[] a : cluster2) {
                            sum += DTW.dtw((Double[])a, (Double[])ts, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                        }
                    }
                    if (j == 2) {
                        ts = t.average(cluster3, (Double[])cluster3.get(i), con);
                        for (Double[] a : cluster3) {
                            sum += DTW.dtw((Double[])a, (Double[])ts, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                        }
                    }
                    totalSum += sum;
                    dtwTotalSum += (DTW.count -= 100.0);
                    if (sum < min) {
                        min = sum;
                        o.drawTimeSeries(name + "-" + j + ".svg", ts);
                    }
                    if (DTW.count < dtwMin) {
                        dtwMin = DTW.count;
                    }
                    if (sum > max) {
                        max = sum;
                        o.drawTimeSeries(name + "-" + j + "-max.svg", ts);
                    }
                    if (!(DTW.count > dtwMax)) continue;
                    dtwMax = DTW.count;
                }
                System.out.println(name + " " + t.getClass().toString());
                System.out.println("Gesamtcluster bei idealer Wahl bez\u00c3\u00bcglich der echten Klassen: ");
                if (n > 1) {
                    System.out.println("min:~" + Math.round(min) + " avg:~" + Math.round(totalSum / (double)n) + " max:\\hfill " + Math.round(max));
                    System.out.println("min:~" + Math.round(dtwMin) + " avg:~" + Math.round(dtwTotalSum / (double)n) + " max:\\hfill " + Math.round(dtwMax));
                    continue;
                }
                System.out.println("\\hfill " + Math.round(totalSum));
                System.out.println("\\hfill " + Math.round(dtwTotalSum));
            }
            ++name;
        }
    }

    private static void exdealSetup() {
        ArrayList<Double[]> cluster1 = new ArrayList<Double[]>(100);
        ArrayList<Double[]> cluster2 = new ArrayList<Double[]>(100);
        ArrayList<Double[]> cluster3 = new ArrayList<Double[]>(100);
        for (int i = 0; i < 100; ++i) {
            Double[] ts3 = CylinderBellFunnel.funnel();
            Double[] ts2 = CylinderBellFunnel.bell();
            Double[] ts1 = CylinderBellFunnel.cylinder();
            if (i < 80) {
                cluster1.add(TimeSeriesClustering.normalize(ts1));
                cluster2.add(TimeSeriesClustering.normalize(ts2));
                cluster3.add(TimeSeriesClustering.normalize(ts3));
                continue;
            }
            if (i < 90) {
                cluster1.add(TimeSeriesClustering.normalize(ts2));
                cluster2.add(TimeSeriesClustering.normalize(ts3));
                cluster3.add(TimeSeriesClustering.normalize(ts1));
                continue;
            }
            cluster1.add(TimeSeriesClustering.normalize(ts3));
            cluster2.add(TimeSeriesClustering.normalize(ts1));
            cluster3.add(TimeSeriesClustering.normalize(ts2));
        }
        SakoeChibaBand con = new SakoeChibaBand(64);
        int name = 0;
        for (AveragingTechnique t : new AveragingTechnique[]{new EuclidianAveraging(), new ProjectionAveraging(), new FixpointAveraging(), new ShapeBasedAveraging(), new FastShapeBasedAveraging()}) {
            for (int j = 0; j < 3; ++j) {
                int n = 1;
                if (t instanceof ProjectionAveraging || t instanceof FixpointAveraging || t instanceof FastShapeBasedAveraging) {
                    n = 100;
                }
                double totalSum = 0.0;
                double min = Double.POSITIVE_INFINITY;
                double max = 0.0;
                double dtwTotalSum = 0.0;
                double dtwMin = Double.POSITIVE_INFINITY;
                double dtwMax = 0.0;
                for (int i = 0; i < n; ++i) {
                    SVGOutput o = new SVGOutput();
                    DTW.count = 0.0;
                    Double[] ts = null;
                    double sum = 0.0;
                    if (j == 0) {
                        ts = t.average(cluster1, (Double[])cluster1.get(i), con);
                        for (Double[] a : cluster1) {
                            sum += DTW.dtw((Double[])a, (Double[])ts, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                        }
                    }
                    if (j == 1) {
                        ts = t.average(cluster2, (Double[])cluster2.get(i), con);
                        for (Double[] a : cluster2) {
                            sum += DTW.dtw((Double[])a, (Double[])ts, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                        }
                    }
                    if (j == 2) {
                        ts = t.average(cluster3, (Double[])cluster3.get(i), con);
                        for (Double[] a : cluster3) {
                            sum += DTW.dtw((Double[])a, (Double[])ts, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                        }
                    }
                    totalSum += sum;
                    dtwTotalSum += (DTW.count -= 100.0);
                    if (sum < min) {
                        min = sum;
                        o.drawTimeSeries("robust-" + name + "-" + j + ".svg", ts);
                    }
                    if (DTW.count < dtwMin) {
                        dtwMin = DTW.count;
                    }
                    if (sum > max) {
                        max = sum;
                        o.drawTimeSeries("robust-" + name + "-" + j + "-max.svg", ts);
                    }
                    if (!(DTW.count > dtwMax)) continue;
                    dtwMax = DTW.count;
                }
                System.out.println(name + " " + t.getClass().toString());
                System.out.println("Gesamtcluster bei idealer Wahl bez\u00c3\u00bcglich der echten Klassen: ");
                if (n > 1) {
                    System.out.println("min:~" + Math.round(min) + " avg:~" + Math.round(totalSum / (double)n) + " max:\\hfill " + Math.round(max));
                    System.out.println("min:~" + Math.round(dtwMin) + " avg:~" + Math.round(dtwTotalSum / (double)n) + " max:\\hfill " + Math.round(dtwMax));
                    continue;
                }
                System.out.println("\\hfill " + Math.round(totalSum));
                System.out.println("\\hfill " + Math.round(dtwTotalSum));
            }
            ++name;
        }
    }
}

