/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering.dataimport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import timeseriesclustering.DTW;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.SakoeChibaBand;
import timeseriesclustering.TimeSeriesClustering;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.EuclidianAveraging;
import timeseriesclustering.averaging.FastShapeBasedAveraging;
import timeseriesclustering.averaging.FixpointAveraging;
import timeseriesclustering.averaging.ProjectionAveraging;
import timeseriesclustering.experiments.SVGOutput;

public class TimeSeriesLoader {
    public LinkedList<Double[]> sequences;
    public HashMap<Double, LinkedList<Double[]>> cluster;
    public HashMap<Double[], Double> classes;

    public TimeSeriesLoader(TimeSeriesClustering c, String filename) {
        try {
            File f = new File(filename);
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String line = "";
            this.sequences = new LinkedList();
            this.cluster = new HashMap();
            this.classes = new HashMap();
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                line = line.replaceAll("  ", " ");
                String[] split = line.split(" ");
                Double[] sequence = new Double[split.length - 1];
                for (int i = 1; i < split.length; ++i) {
                    sequence[i - 1] = Double.parseDouble(split[i]);
                }
                this.sequences.add(sequence);
                Double classId = Double.parseDouble(split[0]);
                if (!this.cluster.containsKey(classId)) {
                    this.cluster.put(classId, new LinkedList());
                }
                this.cluster.get(classId).add(sequence);
                this.classes.put(sequence, classId);
            }
            Collections.shuffle(this.sequences);
            if (c == null) {
                return;
            }
            for (Double[] a : this.sequences) {
                c.addTimeSeries(a);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (File a : new File("datasets").listFiles()) {
            if (!a.isDirectory()) continue;
            for (File b : a.listFiles()) {
                if (!b.getPath().endsWith("TRAIN")) continue;
                filenames.add(b.getPath());
            }
        }
        AveragingTechnique[] averagers = new AveragingTechnique[]{new FastShapeBasedAveraging(), new ProjectionAveraging(), new FixpointAveraging(), new EuclidianAveraging()};
        for (String f : filenames) {
            int name = 0;
            System.out.println(f);
            TimeSeriesClustering a = new TimeSeriesClustering();
            TimeSeriesLoader tsl = new TimeSeriesLoader(a, f);
            for (AveragingTechnique t : averagers) {
                for (int j = 0; j < 1; ++j) {
                    double sum = 0.0;
                    for (Double i : tsl.cluster.keySet()) {
                        Double[] findCentroid = t.average((List<Double[]>)tsl.cluster.get(i), tsl.cluster.get(i).get(new Random().nextInt(tsl.cluster.get(i).size())), new SakoeChibaBand(64));
                        SVGOutput o = new SVGOutput();
                        o.drawTimeSeries(i + "-" + name + ".svg", findCentroid);
                        for (Double[] ts : tsl.cluster.get(i)) {
                            sum += DTW.dtw((Double[])ts, (Double[])findCentroid, (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)new SakoeChibaBand((int)64)).distance;
                        }
                    }
                    System.out.println("theoretisch sind mit " + t.getClass().getName() + " Gesamtkosten von " + sum + " m\u00c3\u00b6glich");
                }
                ++name;
            }
        }
    }
}

