/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering;

import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesclustering.DTW;
import timeseriesclustering.DataLogger;
import timeseriesclustering.DegeneratedClusteringException;
import timeseriesclustering.GlobalConstraint;
import timeseriesclustering.ParallelQueries;
import timeseriesclustering.ParallelQueriesHelper;
import timeseriesclustering.Query;
import timeseriesclustering.averaging.AveragingTechnique;
import timeseriesclustering.averaging.FixpointAveraging;

public class TimeSeriesClustering {
    public static final boolean MULTITHREADING = true;
    private LinkedList<Double[]> database = new LinkedList();
    private ArrayList<Double[]> centers;
    private ArrayList<ArrayList<Double[]>> clusters;
    private RandomGenerator random;
    private double costs;
    private double queryDTWs;
    private int queryDTWcount;

    public RandomGenerator getRandom() {
        return this.random;
    }

    public void setRandom(RandomGenerator random) {
        this.random = random;
    }

    public static Double[] normalize(Double[] ts) {
        double mean = 0.0;
        double std = 0.0;
        Double[] arr$ = ts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double a = arr$[i$];
            mean += a;
            std += a * a;
        }
        std /= (double)ts.length;
        std = Math.sqrt(std - (mean /= (double)ts.length) * mean);
        for (int i = 0; i < ts.length; ++i) {
            ts[i] = (ts[i] - mean) / std;
        }
        return ts;
    }

    public void addTimeSeries(Double[] ts) {
        int i = 0;
        for (Double[] t : this.database) {
            if (ts.length > t.length) {
                this.database.add(i, ts);
                return;
            }
            ++i;
        }
        this.database.add(ts);
    }

    public static void add(Double[] a, Double[] b) {
        for (int i = 0; i < a.length; ++i) {
            Double[] doubleArray = a;
            int n = i;
            Double.valueOf(doubleArray[n] + b[i]);
        }
    }

    public static void divide(Double[] a, double b) {
        int i = 0;
        while (i < a.length) {
            Double[] doubleArray = a;
            int n = i++;
            Double.valueOf(doubleArray[n] / b);
        }
    }

    public void kMeans(int k, GlobalConstraint con, int maxIterations, boolean plusplus, AveragingTechnique averager, DataLogger log) throws DegeneratedClusteringException {
        this.costs = 0.0;
        this.queryDTWcount = 0;
        this.queryDTWs = 0.0;
        ExecutorService e = Executors.newFixedThreadPool(Math.min(32, Math.max(1, Runtime.getRuntime().availableProcessors())));
        this.clusters = this.initializeClusters(k);
        ArrayList<ArrayList<Double[]>> newClusters = this.initializeClusters(k);
        AveragingTechnique[] averagers = averager.duplicateKTimes(k);
        this.centers = plusplus ? this.intializeCentersPlusPlus(k, con) : this.initializeCenters(k);
        ArrayList<Double[]> newCenters = new ArrayList<Double[]>(k);
        FixpointAveraging centerFinder = new FixpointAveraging();
        for (int i = 0; i < k; ++i) {
            newCenters.add(i, new Double[this.centers.get(i).length]);
        }
        boolean movements = false;
        int counter = 0;
        do {
            if (log != null) {
                log.logIteration(counter);
            }
            this.clearClusters(newClusters);
            this.resetCenters(k, newCenters);
            movements = false;
            double sum = 0.0;
            double oldCount = DTW.count;
            ArrayList<ParallelQueries> candidates = new ArrayList<ParallelQueries>();
            for (int i = 0; i < this.database.size(); i += 32) {
                candidates.add(new ParallelQueries(this.database, this.clusters, newClusters, this.centers, con, i, Math.min(this.database.size(), i + 32)));
            }
            try {
                List invokeAll = e.invokeAll(candidates, 10L, TimeUnit.MINUTES);
                for (Future future : invokeAll) {
                    if (!future.isDone()) {
                        System.out.println("Berechnung dauerte zu lange");
                    }
                    sum += ((ParallelQueriesHelper)future.get()).sum;
                    if (!((ParallelQueriesHelper)future.get()).movements) continue;
                    movements = true;
                }
                System.out.flush();
                System.err.flush();
            }
            catch (ExecutionException ex) {
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            for (int i = 0; i < k; ++i) {
                if (log == null) continue;
                log.logClusterSize(newClusters.get(i).size());
            }
            if (log != null) {
                log.logTotalCostPreAverage(sum);
            }
            this.queryDTWs += DTW.count - oldCount;
            this.queryDTWcount += this.database.size() * k;
            double blub = 0.0;
            for (int i = 0; i < k; ++i) {
                if (newClusters.get(i).isEmpty()) {
                    if (log != null) {
                        log.logFailed();
                    }
                    System.err.flush();
                    throw new DegeneratedClusteringException();
                }
                averagers[i].setCluster((List<Double[]>)newClusters.get(i));
                averagers[i].setOldCenter((Double[])this.centers.get(i).clone());
                averagers[i].setCon(con);
            }
            try {
                List invokeAll = e.invokeAll(Arrays.asList(averagers));
                for (int i = 0; i < k; ++i) {
                    newCenters.set(i, (Double[])invokeAll.get(i).get());
                }
            }
            catch (ExecutionException ex) {
                Logger.getLogger(TimeSeriesClustering.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TimeSeriesClustering.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!movements || counter == maxIterations) {
                blub = 0.0;
                for (int i = 0; i < k; ++i) {
                    for (Double[] ts : newClusters.get(i)) {
                        blub += DTW.dtw((Double[])ts, (Double[])newCenters.get((int)i), (double)Double.POSITIVE_INFINITY, (double)0.0, null, null, (GlobalConstraint)con).distance;
                    }
                }
            }
            if (log != null) {
                log.logTotalCost(blub);
            }
            ArrayList<ArrayList<Double[]>> tmp = this.clusters;
            this.clusters = newClusters;
            newClusters = tmp;
            ArrayList<Double[]> tmp2 = this.centers;
            this.centers = newCenters;
            newCenters = tmp2;
            this.costs = blub;
        } while (movements && ++counter <= maxIterations);
        e.shutdownNow();
    }

    public ArrayList<Double[]> getCenters() {
        return this.centers;
    }

    public ArrayList<ArrayList<Double[]>> getClusters() {
        return this.clusters;
    }

    private void resetCenters(int k, ArrayList<Double[]> centers) {
        for (int i = 0; i < k; ++i) {
            Double[] t = centers.get(i);
            for (int j = 0; j < t.length; ++j) {
                t[j] = 0.0;
            }
        }
    }

    private ArrayList<Double[]> intializeCentersPlusPlus(int k, GlobalConstraint con) {
        ArrayList<Double[]> centers = new ArrayList<Double[]>(1);
        int init = this.random.nextInt(this.database.size());
        HashSet<Integer> centerIds = new HashSet<Integer>();
        centerIds.add(init);
        centers.add(0, (Double[])this.database.get(init).clone());
        double[] weights = new double[this.database.size()];
        for (int i = 1; i < k; ++i) {
            double totalWeight = 0.0;
            for (int j = 0; j < this.database.size(); ++j) {
                if (centerIds.contains(j)) {
                    weights[j] = 0.0;
                    continue;
                }
                weights[j] = new Query(centers, (Double[])this.database.get((int)j), (GlobalConstraint)con).dtw.distance;
                int n = j;
                weights[n] = weights[n] * weights[j];
                totalWeight += weights[j];
            }
            double winner = this.random.nextDouble() * totalWeight;
            double runningSum = 0.0;
            int j = 0;
            while (runningSum < winner) {
                runningSum += weights[j];
                ++j;
            }
            centers.add((Double[])this.database.get(j - 1).clone());
            centerIds.add(j - 1);
        }
        return centers;
    }

    private ArrayList<Double[]> initializeCenters(int k) {
        RandomGenerator r = this.random;
        ArrayList<Double[]> centers = new ArrayList<Double[]>(k);
        HashSet<Integer> ids = new HashSet<Integer>(k - 1);
        for (int i = 0; i < k; ++i) {
            int id = r.nextInt(this.database.size());
            while (ids.contains(id)) {
                id = r.nextInt(this.database.size());
            }
            centers.add(i, (Double[])this.database.get(id).clone());
            ids.add(id);
        }
        Collections.sort(centers, new Comparator<Double[]>(){

            @Override
            public int compare(Double[] t, Double[] t1) {
                return t.length - t1.length;
            }
        });
        return centers;
    }

    private ArrayList<ArrayList<Double[]>> initializeClusters(int k) {
        ArrayList<ArrayList<Double[]>> cluster = new ArrayList<ArrayList<Double[]>>(k);
        for (int i = 0; i < k; ++i) {
            cluster.add(i, new ArrayList());
        }
        return cluster;
    }

    private void clearClusters(ArrayList<ArrayList<Double[]>> newCluster) {
        for (ArrayList<Double[]> a : newCluster) {
            a.clear();
        }
    }

    public double getCosts() {
        return this.costs;
    }

    public double getDTWRatio() {
        return this.queryDTWs / (double)this.queryDTWcount;
    }
}

