/*
 * Decompiled with CFR 0.152.
 */
package timeseriesclustering;

import java.util.LinkedList;
import timeseriesclustering.DTWInformation;
import timeseriesclustering.GlobalConstraint;

public class DTW {
    public static double count;

    public static double getFromDTWMatrix(double[][] dtw, int[][] ranges, int x, int y) {
        return ranges[x][0] <= y && y < ranges[x][1] ? dtw[x][y - ranges[x][0]] : Double.POSITIVE_INFINITY;
    }

    public static DTWInformation dtw(Double[] q, Double[] c, double bestSoFar, double lb_keogh, Double[] u, Double[] l, GlobalConstraint constraint) {
        if (q == null) {
            System.err.println("hier gehts schief");
        }
        double[][] dtw = new double[q.length][];
        int[][] ranges = new int[q.length][];
        for (int i = 0; i < q.length; ++i) {
            int[] range = constraint.possibleYsForX(i, q.length, c.length);
            ranges[i] = range;
            dtw[i] = new double[range[1] - range[0]];
            double min = Double.POSITIVE_INFINITY;
            for (int j = range[0]; j < range[1]; ++j) {
                int jj = j - range[0];
                if (i == 0 && j == 0) {
                    dtw[i][jj] = 0.0;
                    min = 0.0;
                    continue;
                }
                if (i == 0 && j != 0) {
                    dtw[i][jj] = DTW.getFromDTWMatrix(dtw, ranges, i, j - 1) + (q[0] - c[j]) * (q[0] - c[j]);
                    if (!(dtw[i][jj] < min)) continue;
                    min = dtw[i][jj];
                    continue;
                }
                if (i != 0 && j == 0) {
                    dtw[i][jj] = DTW.getFromDTWMatrix(dtw, ranges, i, j - 1) + (q[i] - c[0]) * (q[i] - c[0]);
                    if (!(dtw[i][jj] < min)) continue;
                    min = dtw[i][jj];
                    continue;
                }
                dtw[i][jj] = (q[i] - c[j]) * (q[i] - c[j]);
                double[] dArray = dtw[i];
                int n = jj;
                dArray[n] = dArray[n] + Math.min(DTW.getFromDTWMatrix(dtw, ranges, i - 1, j), Math.min(DTW.getFromDTWMatrix(dtw, ranges, i, j - 1), DTW.getFromDTWMatrix(dtw, ranges, i - 1, j - 1)));
                if (!(dtw[i][jj] < min)) continue;
                min = dtw[i][jj];
            }
            if (min + lb_keogh > bestSoFar) {
                count += 1.0 * (double)i / (double)q.length;
                return new DTWInformation(bestSoFar + 1.0, null);
            }
            if (!(lb_keogh > 0.0)) continue;
            if (q[i] < l[i]) {
                lb_keogh -= (q[i] - l[i]) * (q[i] - l[i]);
            }
            if (!(q[i] > u[i])) continue;
            lb_keogh -= (q[i] - u[i]) * (q[i] - u[i]);
        }
        int[][] warpingPath = DTW.constructWarpingPath(dtw, ranges, q.length - 1, c.length - 1);
        count += 1.0;
        return new DTWInformation(DTW.getFromDTWMatrix(dtw, ranges, q.length - 1, c.length - 1), warpingPath);
    }

    public static double lb_kim_FL(Double[] ts1, Double[] ts2) {
        int n = ts1.length - 1;
        int m = ts2.length - 1;
        return Math.max((ts1[0] - ts2[0]) * (ts1[0] - ts2[0]), (ts1[n] - ts2[m]) * (ts1[n] - ts2[m]));
    }

    public static Double[][] upperAndLowerBoundSeries(Double[] q, Double[] c, GlobalConstraint con) {
        Double[] u = new Double[c.length];
        Double[] l = new Double[c.length];
        for (int i = 0; i < c.length; ++i) {
            int[] range = con.possibleYsForX(i, c.length, q.length);
            l[i] = Double.POSITIVE_INFINITY;
            u[i] = Double.NEGATIVE_INFINITY;
            for (int j = range[0]; j < range[1]; ++j) {
                l[i] = Math.min(l[i], q[j]);
                u[i] = Math.max(u[i], q[j]);
            }
        }
        return new Double[][]{u, l};
    }

    public static double lb_keogh(Double[] ts, Double[] u, Double[] l, double bestSoFar) {
        double runningSum = 0.0;
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] < l[i]) {
                runningSum += (ts[i] - l[i]) * (ts[i] - l[i]);
            }
            if (ts[i] > u[i]) {
                runningSum += (ts[i] - u[i]) * (ts[i] - u[i]);
            }
            if (!(runningSum > bestSoFar)) continue;
            return bestSoFar + 1.0;
        }
        return runningSum;
    }

    public static Double[] averageWarpingPath(Double[] c, Double[] q, double[][] dtw, int[][] ranges) {
        int i;
        Double[] alignment = new Double[c.length];
        for (i = 0; i < c.length; ++i) {
            alignment[i] = 0.0;
        }
        i = q.length - 1;
        int j = c.length - 1;
        int count = 0;
        while (i >= 0 && j >= 0) {
            Double[] doubleArray = alignment;
            int n = j;
            Double.valueOf(doubleArray[n] + q[i]);
            ++count;
            if (i == 0) {
                doubleArray = alignment;
                n = j--;
                Double.valueOf(doubleArray[n] / (double)count);
                count = 0;
                continue;
            }
            if (j == 0) {
                --i;
                continue;
            }
            if (DTW.getFromDTWMatrix(dtw, ranges, i, j - 1) < DTW.getFromDTWMatrix(dtw, ranges, i - 1, j)) {
                if (DTW.getFromDTWMatrix(dtw, ranges, i, j - 1) < DTW.getFromDTWMatrix(dtw, ranges, i - 1, j - 1)) {
                    doubleArray = alignment;
                    n = j--;
                    Double.valueOf(doubleArray[n] / (double)count);
                    count = 0;
                    continue;
                }
                doubleArray = alignment;
                n = j--;
                Double.valueOf(doubleArray[n] / (double)count);
                count = 0;
                --i;
                continue;
            }
            if (DTW.getFromDTWMatrix(dtw, ranges, i - 1, j) < DTW.getFromDTWMatrix(dtw, ranges, i - 1, j - 1)) {
                --i;
                continue;
            }
            doubleArray = alignment;
            n = j--;
            Double.valueOf(doubleArray[n] / (double)count);
            count = 0;
            --i;
        }
        return alignment;
    }

    private static int[][] constructWarpingPath(double[][] dtw, int[][] ranges, int i, int j) {
        LinkedList<int[]> path = new LinkedList<int[]>();
        while (i >= 0 && j >= 0) {
            path.addFirst(new int[]{i, j--});
            if (i == 0) continue;
            if (j == 0) {
                --i;
                continue;
            }
            if (DTW.getFromDTWMatrix(dtw, ranges, i, j - 1) < DTW.getFromDTWMatrix(dtw, ranges, i - 1, j)) {
                if (DTW.getFromDTWMatrix(dtw, ranges, i, j - 1) < DTW.getFromDTWMatrix(dtw, ranges, i - 1, j - 1)) {
                    --j;
                    continue;
                }
                --j;
                --i;
                continue;
            }
            if (DTW.getFromDTWMatrix(dtw, ranges, i - 1, j) < DTW.getFromDTWMatrix(dtw, ranges, i - 1, j - 1)) {
                --i;
                continue;
            }
            --j;
            --i;
        }
        int[][] ret = new int[path.size()][];
        for (int k = 0; k < path.size(); ++k) {
            ret[k] = (int[])path.get(k);
        }
        return ret;
    }
}

